/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.util.Locale;
import javax.swing.JButton;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import misc.Bundle;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.runner.JUnitCore;

public class BundleTest
extends Assert {
    public static int countObserver;
    public static int countActioner;

    public static Test suite() {
        return new JUnit4TestAdapter(BundleTest.class);
    }

    public static void main(String[] args) {
        JUnitCore.main((String[])new String[]{"misc.BundleTest"});
    }

    @BeforeClass
    public static void setBundleObserver() {
        Bundle.addBundleObserver(new Object(){

            public void updateBundle() {
                ++countObserver;
            }
        });
        Bundle.load("BundleManager", Locale.US);
        String action = "Quit";
        JButton button = new JButton(Bundle.getAction(action)){
            private static final long serialVersionUID = 1L;

            @Override
            public void setText(String text) {
                super.setText(text);
                ++countActioner;
            }
        };
        Bundle.addLocalizedActioner(button);
        button.setActionCommand(action);
    }

    @org.junit.Test
    public void setLocale() {
        Bundle.load("BundleManager", Locale.US);
        int oldValue = countObserver;
        Bundle.setLocale(Locale.FRANCE);
        BundleTest.assertTrue((oldValue + 1 == countObserver ? 1 : 0) != 0);
        BundleTest.assertTrue((countActioner == countObserver ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void load() {
        int oldValue = countObserver;
        Bundle.load("BundleManager");
        BundleTest.assertTrue((oldValue + 1 == countObserver ? 1 : 0) != 0);
        BundleTest.assertTrue((countActioner == countObserver ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void getLocales() {
        Locale[] locales = Bundle.getApplicationsLocales();
        BundleTest.assertTrue((locales.length > 0 ? 1 : 0) != 0);
        Bundle.load("BundleManager");
        for (Locale locale : locales) {
            Bundle.setLocale(locale);
        }
    }

    @org.junit.Test
    public void getString() {
        Bundle.load("BundleManager", Locale.US);
        String s1 = Bundle.getTitle("BundleEditor");
        Bundle.setLocale(Locale.FRANCE);
        String s2 = Bundle.getTitle("BundleEditor");
        BundleTest.assertNotNull((Object)s1);
        BundleTest.assertNotNull((Object)s2);
        BundleTest.assertFalse((boolean)s1.equals(s2));
    }
}

