/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.SocketException;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.TreeSet;
import misc.Bundle;
import misc.CommandLineServer;
import misc.Log;
import misc.Util;

public class CommandLineWaiter<Model> {
    public static final int MAX_COL = 6;
    protected Model model;
    protected CommandLineServer<Model> commandLineServer;
    private TreeSet<String> commands;
    private Hashtable<String, String> help;
    private Hashtable<String, Method> actionsMethod;
    protected Socket call;
    protected BufferedReader in;
    protected PrintWriter out;
    protected String line;
    protected StringTokenizer arguments;

    public boolean hasMoreArg() {
        return this.arguments.hasMoreTokens();
    }

    public String nextArg() {
        return this.arguments.nextToken().trim();
    }

    public void startCall() {
    }

    public String getCommandLine(BufferedReader in) throws IOException {
        try {
            return in.readLine().trim();
        }
        catch (SocketException e) {
            return null;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public void answerln(String str) {
        this.out.println(str);
        this.out.flush();
    }

    public void syntaxError() {
        this.answerln(Bundle.getMessage("SyntaxeError"));
    }

    public void actionHelp() {
        String arg = null;
        if (this.hasMoreArg()) {
            arg = this.nextArg().toLowerCase();
        }
        if (arg == null || arg.isEmpty()) {
            this.answerln(Bundle.getString("Help" + this.commandLineServer.getClassWaiterName() + "_", null).replaceAll("\\\\n", "\n") + Util.toColumn(Util.set2string(this.commands), 6));
        } else {
            String explanation = this.help.get(arg);
            if (explanation == null) {
                this.answerln(MessageFormat.format(Bundle.getMessage("NotACommand"), arg));
            } else {
                this.answerln(arg.toLowerCase() + " " + explanation);
            }
        }
    }

    public void actionQuit() {
        this.answerln(Bundle.getMessage("SeeYouSoon").replaceAll("\\\\n", "\n"));
        try {
            this.call.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void actionExit() {
        this.answerln(Bundle.getMessage("GoodBye").replaceAll("\\\\n", "\n"));
        System.exit(0);
    }

    public CommandLineWaiter(CommandLineServer<Model> commandLineServer, Model model, Socket call) {
        block2: {
            this.commandLineServer = commandLineServer;
            this.model = model;
            this.call = call;
            this.commands = commandLineServer.getCommands();
            this.help = commandLineServer.getHelp();
            this.actionsMethod = commandLineServer.getActionsMethod();
            try {
                this.in = new BufferedReader(new InputStreamReader(call.getInputStream()));
                this.out = new PrintWriter(call.getOutputStream());
                this.startCall();
                new Thread(){

                    @Override
                    public void run() {
                        CommandLineWaiter.this.analyse();
                    }
                }.start();
            }
            catch (IOException e) {
                if (call.isClosed()) break block2;
                Log.keepLastException("CommandLineWaiter", e);
            }
        }
    }

    public void analyse() {
        String cmd = null;
        try {
            while (!this.call.isClosed()) {
                this.line = this.getCommandLine(this.in);
                if (this.line == null) {
                    break;
                }
                if (this.line.isEmpty()) continue;
                this.arguments = new StringTokenizer(this.line);
                if (!this.arguments.hasMoreTokens()) continue;
                cmd = this.arguments.nextToken().trim().toLowerCase();
                if (this.commands.contains(cmd)) {
                    this.actionsMethod.get(cmd).invoke((Object)this, new Object[0]);
                    continue;
                }
                this.answerln(MessageFormat.format(Bundle.getMessage("NotACommand"), cmd));
            }
        }
        catch (Exception e) {
            Log.keepLastException("CommandLineWaiter::analyse (" + cmd + ")", e);
        }
        finally {
            try {
                this.call.close();
            }
            catch (Exception exception) {}
        }
    }
}

