/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.awt.Container;
import java.awt.Point;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import misc.Config;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.runner.JUnitCore;

public class ConfigTest
extends Assert {
    public static final String testApplicationName = "Test";
    public static final String testConfigFileName = Config.configSystemDir + System.getProperty("file.separator") + "Test" + ".xml";
    public static final String result = "result";
    public static final String booleanTrue = "booleanTrue";
    public static final String example = "example";
    public static final String value = "value";
    public static final String configContent = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<!DOCTYPE properties SYSTEM \"http://java.sun.com/dtd/properties.dtd\">\n<properties>\n  <entry key=\"FrameLocation\">[x=100,y=200]</entry>\n  <entry key=\"example\">value</entry>\n  <entry key=\"booleanTrue\">true</entry>\n</properties>\n";

    public static Test suite() {
        return new JUnit4TestAdapter(ConfigTest.class);
    }

    public static void main(String[] args) {
        JUnitCore.main((String[])new String[]{"misc.ConfigTest"});
    }

    public int getLines(String fileName) throws FileNotFoundException, IOException {
        long fileSize = new File(fileName).length();
        LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(fileName));
        lineNumberReader.skip(fileSize);
        return lineNumberReader.getLineNumber();
    }

    @BeforeClass
    public static void createTestConfig() throws FileNotFoundException {
        PrintWriter configFile = new PrintWriter(testConfigFileName);
        configFile.write(configContent);
        configFile.close();
    }

    @AfterClass
    public static void removeTestConfig() {
        new File(testConfigFileName).delete();
    }

    @org.junit.Test
    public void load() {
        boolean findFile = false;
        for (String fileName : new File(Config.configSystemDir).list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        })) {
            findFile = true;
            Config.setPWD(ConfigTest.class);
            Config.load(fileName.substring(0, fileName.length() - ".xml".length()));
            ConfigTest.assertTrue((boolean)Config.isLoaded());
        }
        ConfigTest.assertTrue((boolean)findFile);
    }

    @org.junit.Test
    public void getString() {
        Config.setPWD(ConfigTest.class);
        Config.load(testApplicationName);
        ConfigTest.assertEquals((Object)result, (Object)Config.getString(null, result));
        ConfigTest.assertEquals((Object)value, (Object)Config.getString(example));
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void getStringNullKey() {
        Config.getString(null);
    }

    @org.junit.Test
    public void getBoolean() {
        Config.setPWD(ConfigTest.class);
        Config.load(testApplicationName);
        ConfigTest.assertTrue((boolean)Config.getBoolean(booleanTrue, false));
        ConfigTest.assertFalse((boolean)Config.getBoolean(example, false));
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void getBooleanNullKey() {
        Config.getBoolean(null);
    }

    @org.junit.Test
    public void save() throws FileNotFoundException, IOException {
        int lines = this.getLines(testConfigFileName);
        Config.setPWD(ConfigTest.class);
        Config.load(testApplicationName);
        Config.setString("a", "b");
        Config.save(testApplicationName);
        ConfigTest.assertTrue((lines < this.getLines(testConfigFileName) ? 1 : 0) != 0);
        Config.load(testApplicationName);
        ConfigTest.assertEquals((Object)"b", (Object)Config.getString("a"));
    }

    @org.junit.Test
    public void setString() {
        Config.setPWD(ConfigTest.class);
        Config.load(testApplicationName);
        Config.setString("a", "b");
        ConfigTest.assertEquals((Object)"b", (Object)Config.getString("a"));
    }

    @org.junit.Test
    public void setBoolean() {
        Config.setPWD(ConfigTest.class);
        Config.load(testApplicationName);
        Config.setBoolean("bool", true);
        ConfigTest.assertTrue((boolean)Config.getBoolean("bool"));
        Config.setBoolean("bool", false);
        ConfigTest.assertFalse((boolean)Config.getBoolean("bool"));
    }

    @org.junit.Test
    public void saveLocation() {
        Config.setPWD(ConfigTest.class);
        Config.load(testApplicationName);
        ConfigTest.assertNull((Object)Config.getString("testLocation", null));
        Container container = new Container();
        container.setLocation(10, 20);
        Config.saveLocation("test", container);
        ConfigTest.assertEquals((Object)"[x=10,y=20]", (Object)Config.getString("testLocation"));
    }

    @org.junit.Test
    public void loadLocation() {
        Config.setPWD(ConfigTest.class);
        Config.load(testApplicationName);
        Container container = new Container();
        Config.loadLocation("Frame", container, new Point(0, 0));
        ConfigTest.assertEquals((Object)new Point(100, 200), (Object)container.getLocation());
    }
}

