/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JTextField;

public class DatePanel
extends JTextField
implements KeyListener,
FocusListener {
    public static final SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
    public static final String acceptChar = "0123456789/+- 3840";
    private Dimension tmpSize = new Dimension();
    private Dimension size;
    public static int min2ky;
    public static int max2ky;
    public static int cur2ky;

    public DatePanel() {
        super("31/12/9999");
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.set(new Date());
    }

    public void enter() {
        this.tune2ky();
    }

    public void set(Date date) {
        this.setText(dateFormat.format(date));
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int c = e.getKeyCode();
        switch (c) {
            case 38: {
                this.incr(1);
                e.consume();
                return;
            }
            case 40: {
                this.incr(-1);
                e.consume();
                return;
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        char c = e.getKeyChar();
        switch (c) {
            case '\n': {
                this.enter();
                return;
            }
            case ';': {
                e.consume();
                return;
            }
            case '\b': {
                return;
            }
            case ' ': {
                this.setText("");
                e.consume();
                return;
            }
            case '+': {
                this.incr(1);
                e.consume();
                return;
            }
            case '-': {
                this.incr(-1);
                e.consume();
                return;
            }
        }
        if (acceptChar.indexOf(c) < 0) {
            e.consume();
            return;
        }
        if (this.getSelectedText() == null && this.getText().length() >= 12) {
            e.consume();
            return;
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.tune2ky();
    }

    public void tune2ky() {
        try {
            Date origDate = dateFormat.parse(this.getText().trim());
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(origDate);
            int y = cal.get(1);
            if (y < 100) {
                cal.add(1, cur2ky);
                if (y < min2ky) {
                    cal.add(1, 100);
                } else if (y > max2ky) {
                    cal.add(1, -100);
                }
            }
            this.setText(dateFormat.format(cal.getTime()));
            this.getSize(this.tmpSize);
            if (this.tmpSize.width != 0) {
                this.size = this.tmpSize;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.size != null) {
            return this.size;
        }
        return super.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.size != null) {
            return this.size;
        }
        return super.getPreferredSize();
    }

    public void incr(int incr) {
        try {
            this.tune2ky();
            Date origDate = dateFormat.parse(this.getText().trim());
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(origDate);
            cal.add(5, incr);
            this.setText(dateFormat.format(cal.getTime()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date());
        int y = cal.get(1);
        int yMod1ky = y % 100;
        min2ky = yMod1ky - 50;
        max2ky = yMod1ky + 50;
        cur2ky = y - yMod1ky;
    }
}

