/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import misc.HtmlDialog;
import misc.Log;

public class Guide
extends HtmlDialog {
    public static final int H_SPACE = 5;
    public static final int V_SPACE = 2;
    Color standardBackground = Color.gray;
    Color highlightColor = Color.orange;
    Component[] component;
    Color[] componentBackgroundColor;
    int next = -1;
    boolean[] done;

    public Guide(Frame frame, String titleName, String fileName, Component[] component, Color standardBackground, Color highlightColor) {
        super(frame, titleName, fileName);
        this.component = component;
        this.standardBackground = standardBackground;
        this.highlightColor = highlightColor;
        this.done = new boolean[component.length];
        this.componentBackgroundColor = new Color[component.length];
        for (int i = 0; i < component.length; ++i) {
            if (component[i] == null) continue;
            this.componentBackgroundColor[i] = component[i].getBackground();
        }
        this.reset();
        this.editorPane.addHyperlinkListener(new Hyperactive());
    }

    @Override
    public void setVisible(boolean visible) {
        this.reset();
        super.setVisible(visible);
        if (visible) {
            this.setNext();
            this.editorPane.scrollToReference("Top");
        }
    }

    public void changeHtmlClassAction(String actionName, String className) {
        String newPage = this.editorPane.getText().replaceAll("<div[^>]*name=\"Action(" + actionName + ")\"[^>]*>", "<div name=\"Action$1\" class=\"" + className.toLowerCase() + "\">").replaceAll("<img[^>]*name=\"Action(" + actionName + ")\"[^>]*>", "<img name=\"Action$1\" border=\"0\" src=\"../images/button/" + className + ".png\">");
        this.editorPane.setText(newPage);
    }

    public void reset() {
        this.next = -1;
        if (this.done == null) {
            return;
        }
        for (int step = 0; step < this.done.length; ++step) {
            this.done[step] = false;
            if (this.component[step] == null) continue;
            this.component[step].setBackground(this.componentBackgroundColor[step]);
        }
        this.editorPane.getText();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.changeHtmlClassAction("(G[0-9]+-)?[0-9]+", "Unknown");
        this.editorPane.scrollToReference("Top");
    }

    public void unsetNext() {
        if (this.next < 0) {
            return;
        }
        this.changeHtmlClassAction("" + this.next, "Unknown");
        if (this.component[this.next] != null) {
            this.component[this.next].setBackground(this.componentBackgroundColor[this.next]);
        }
        this.next = -1;
    }

    public void setNext() {
        if (this.next >= 0 && !this.done[this.next]) {
            return;
        }
        this.next = -1;
        for (int step = 0; step < this.done.length; ++step) {
            if (this.done[step]) continue;
            this.next = step;
            this.changeHtmlClassAction("" + this.next, "Todo");
            if (this.component[this.next] != null) {
                this.component[this.next].setBackground(this.highlightColor);
            }
            this.editorPane.scrollToReference("Action" + this.next);
            return;
        }
    }

    private void stepIsDone(int step) {
        this.done[step] = true;
        this.changeHtmlClassAction("" + step, "Done");
        if (this.component[step] != null) {
            this.component[step].setBackground(this.componentBackgroundColor[step]);
        }
    }

    private void stepIsUnknown(int step) {
        this.done[step] = false;
        this.changeHtmlClassAction("" + step, "Unknown");
    }

    public void flipStep(int step) {
        this.unsetNext();
        if (this.done[step]) {
            this.stepIsUnknown(step);
        } else {
            this.stepIsDone(step);
        }
        this.checkGroup();
        this.setNext();
    }

    public void flipGroup(int step1, int step2) {
        int step;
        this.unsetNext();
        boolean allDone = true;
        for (step = step1; step <= step2; ++step) {
            if (this.done[step]) continue;
            allDone = false;
            break;
        }
        if (allDone) {
            for (step = step1; step <= step2; ++step) {
                this.stepIsUnknown(step);
            }
            this.changeHtmlClassAction("G" + step1 + "-" + step2, "Unknown");
        } else {
            for (step = step1; step <= step2; ++step) {
                this.stepIsDone(step);
            }
            this.changeHtmlClassAction("G" + step1 + "-" + step2, "Done");
        }
        this.checkGroup();
        this.setNext();
    }

    public void checkGroup() {
        String newPage = this.editorPane.getText();
        Pattern pattern = Pattern.compile("<img[^>]*name=\"ActionG(([0-9]+)-([0-9]+))\"[^>]*>");
        Matcher matcher = pattern.matcher(newPage);
        while (matcher.find()) {
            int step1 = Integer.parseInt(matcher.group(2));
            int step2 = Integer.parseInt(matcher.group(3));
            boolean allDone = true;
            for (int step = step1; step <= step2; ++step) {
                if (this.done[step]) continue;
                allDone = false;
                break;
            }
            this.changeHtmlClassAction("G" + step1 + "-" + step2, allDone ? "Done" : "Unknown");
        }
    }

    class Hyperactive
    implements HyperlinkListener {
        Hyperactive() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String file = e.getURL().getPath();
                String command = file.substring(file.lastIndexOf("/") + 1);
                int idx = command.indexOf("?");
                if (idx >= 0) {
                    command = command.substring(0, idx);
                }
                if ("Reset".equals(command)) {
                    Guide.this.reset();
                    Guide.this.setNext();
                } else if (command.startsWith("ActionG")) {
                    String[] bound = command.substring("ActionG".length()).split("\\-");
                    Guide.this.flipGroup(Integer.parseInt(bound[0]), Integer.parseInt(bound[1]));
                } else if (command.startsWith("Action")) {
                    Guide.this.flipStep(Integer.parseInt(command.substring("Action".length())));
                } else if (e instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                    HTMLDocument doc = (HTMLDocument)Guide.this.editorPane.getDocument();
                    doc.processHTMLFrameHyperlinkEvent(evt);
                } else {
                    try {
                        Guide.this.editorPane.setPage(e.getURL());
                    }
                    catch (Throwable t) {
                        Log.keepLastException("Guide::hyperlinkUpdate", t);
                    }
                }
            }
        }
    }
}

