/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import misc.Config;
import misc.TitledDialog;

public class HtmlDialog
extends TitledDialog {
    public JEditorPane editorPane;
    protected URL startedURL;
    HyperlinkListener hyperlinkListener = new HyperlinkListener(){

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                if (e instanceof HTMLFrameHyperlinkEvent) {
                    ((HTMLDocument)HtmlDialog.this.editorPane.getDocument()).processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)e);
                } else {
                    try {
                        HtmlDialog.this.editorPane.setPage(e.getURL());
                    }
                    catch (Exception ioe) {
                        System.err.println("IOE: " + ioe);
                    }
                }
            }
        }
    };

    public HtmlDialog(Frame frame, String titleName, String fileName) {
        super(frame, titleName);
        this.editorPane = new JEditorPane();
        this.changeFileName(fileName);
        this.editorPane.setBackground(this.getBackground());
        this.editorPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createEmptyBorder(2, 5, 2, 5)));
        this.editorPane.setEditable(false);
        this.editorPane.setCaretPosition(0);
        this.editorPane.scrollToReference("Top");
        JScrollPane editorScrollPane = new JScrollPane(this.editorPane);
        editorScrollPane.setVerticalScrollBarPolicy(22);
        editorScrollPane.setPreferredSize(new Dimension(600, 300));
        this.getContentPane().add((Component)editorScrollPane, "Center");
    }

    public void changeFileName(String fileName) {
        try {
            URL newURL = Config.getDataUrl(fileName);
            if (newURL.equals(this.startedURL)) {
                return;
            }
            this.startedURL = newURL;
            this.restart();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void restart() {
        try {
            this.editorPane.setPage(this.startedURL);
            this.editorPane.setDragEnabled(true);
            this.editorPane.removeHyperlinkListener(this.hyperlinkListener);
            this.editorPane.addHyperlinkListener(this.hyperlinkListener);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

