/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.awt.Component;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import misc.Bundle;
import misc.Config;

public class Log {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("[yyyy/MM/dd HH:mm:ss] ");
    public static final boolean debug = true;
    public static Hashtable<String, String> lastExceptions = new Hashtable();
    public static boolean keepLastException;
    private static Vector<AbstractButton> dumpCommands;

    public static void writeLog(String serviceName, String message) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(Config.getString("logPath", Config.logSystemDir) + Config.FS + serviceName + ".log", true));
            out.write(dateFormat.format(new Date()) + message + "\n");
            out.flush();
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void keepLastException(String where, Throwable t) {
        try {
            t.printStackTrace();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(baos);
            printWriter.println("Exception:\nDate: " + dateFormat.format(new Date()) + "\n");
            t.printStackTrace(printWriter);
            printWriter.flush();
            printWriter.close();
            lastExceptions.put(where, baos.toString("ISO-8859-1"));
            System.err.println("Exception " + t + " find in " + where + "\nSee log file.");
            keepLastException = true;
            for (AbstractButton dumpCommand : dumpCommands) {
                dumpCommand.setEnabled(keepLastException);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpLastException(File file) {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter(file));
            for (String where : lastExceptions.keySet()) {
                printWriter.println("\n\nContext: " + where + "\n" + lastExceptions.get(where));
            }
            printWriter.flush();
        }
        catch (Exception exception) {
        }
        finally {
            try {
                printWriter.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void dumpSaveDialog(Component component) {
        JFileChooser dumpChooser = new JFileChooser(Config.getString("dumpDir", Config.logSystemDir));
        dumpChooser.setFileFilter(new FileNameExtensionFilter(Bundle.getLabel("DumpFilter"), ".log"));
        dumpChooser.setDialogTitle(Bundle.getTitle("Dump"));
        if (dumpChooser.showSaveDialog(component) != 0) {
            return;
        }
        Log.dumpLastException(dumpChooser.getSelectedFile());
    }

    public static void addDumpCommand(AbstractButton dumpCommand) {
        if (dumpCommand == null) {
            return;
        }
        dumpCommands.add(dumpCommand);
        dumpCommand.setEnabled(keepLastException);
    }

    public static void removeDumpCommand(AbstractButton dumpCommand) {
        dumpCommands.remove(dumpCommand);
    }

    static {
        dumpCommands = new Vector();
    }
}

