/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class Plugins {
    public static final Long version = 20170527L;
    public static final String[] stateLabel = new String[]{"not found", "old version", "updated"};
    public static final ImageIcon[] stateIcon = new ImageIcon[]{Plugins.loadImageIcon("Bad"), Plugins.loadImageIcon("Warning"), Plugins.loadImageIcon("Good")};
    static ArrayList<PluginInfo> pluginsInfo = new ArrayList();
    public static JDialog jDialog;
    public static boolean warning;

    public static URL getDataUrl(String name) {
        try {
            File file = new File(name);
            if (file.exists()) {
                URL result = file.toURI().toURL();
                return result;
            }
        }
        catch (Exception file) {
            // empty catch block
        }
        try {
            URL result = ClassLoader.getSystemResource(name);
            return result;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static ImageIcon loadImageIcon(String name) {
        URL url = Plugins.getDataUrl("data/images/button/" + name + ".png");
        return url != null ? new ImageIcon(url) : null;
    }

    public static void check(String name, String url, String className, boolean mandatory, Long dateNeed) {
        PluginInfo pluginInfo = new PluginInfo(name, url, mandatory);
        pluginsInfo.add(pluginInfo);
        try {
            Class<?> plugin = ClassLoader.getSystemClassLoader().loadClass(className);
            pluginInfo.loaded = true;
            pluginInfo.update = dateNeed == null || dateNeed <= (Long)plugin.getDeclaredField("version").get(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void showSate() {
        Vector<Vector<Serializable>> data = new Vector<Vector<Serializable>>();
        boolean ready = true;
        for (PluginInfo pluginInfo : pluginsInfo) {
            int state;
            ready &= !pluginInfo.mandatory || pluginInfo.loaded;
            int n = pluginInfo.loaded ? (pluginInfo.update ? 2 : 1) : (state = 0);
            if (state != 2) {
                warning = true;
            }
            data.add(new Vector<Serializable>(Arrays.asList(pluginInfo.name, stateIcon[state], stateLabel[state], pluginInfo.update ? "" : pluginInfo.url)));
        }
        Vector<String> columnNames = new Vector<String>(Arrays.asList("Plugin name", "", "State", "URL"));
        JTable table = new JTable(data, (Vector)columnNames){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component prepareRenderer = super.prepareRenderer(renderer, row, column);
                TableColumn tableColumn = this.getColumnModel().getColumn(column);
                int width = Math.max(prepareRenderer.getPreferredSize().width, tableColumn.getPreferredWidth());
                tableColumn.setPreferredWidth(width);
                return prepareRenderer;
            }
        };
        table.setDefaultRenderer(Object.class, new ImageCellRenderer());
        TableCellRenderer renderer = table.getTableHeader().getDefaultRenderer();
        for (int i = 0; i < table.getColumnCount(); ++i) {
            int width = renderer.getTableCellRendererComponent((JTable)table, (Object)table.getModel().getColumnName((int)i), (boolean)false, (boolean)false, (int)0, (int)i).getPreferredSize().width;
            TableColumn tableColumn = table.getColumnModel().getColumn(i);
            tableColumn.setPreferredWidth(width);
        }
        JPanel container = new JPanel();
        container.setLayout(new BorderLayout());
        container.add((Component)table.getTableHeader(), "First");
        container.add((Component)table, "Center");
        if (!ready) {
            Dimension containerSize = container.getSize();
            containerSize.width = Math.max(containerSize.width, 600);
            containerSize.height = Math.max(containerSize.height, 100);
            container.setPreferredSize(containerSize);
            container.add((Component)new JLabel("Would you like to continue?"), "Last");
            if (0 != JOptionPane.showConfirmDialog(null, container, " Can't load plugins ", 0)) {
                System.exit(1);
            }
            return;
        }
        jDialog = new JDialog((Frame)null, " Plugins state ", false);
        jDialog.getContentPane().add((Component)container, "Center");
        jDialog.setVisible(true);
        jDialog.pack();
        jDialog.setLocationRelativeTo(null);
        jDialog.toFront();
    }

    public static void hideSate() {
        if (jDialog == null) {
            return;
        }
        jDialog.pack();
        if (!warning) {
            jDialog.setVisible(false);
        }
    }

    static {
        warning = false;
    }

    public static class ImageCellRenderer
    extends JLabel
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof ImageIcon) {
                this.setIcon((ImageIcon)value);
                this.setText(null);
            } else {
                this.setIcon(null);
                this.setText((String)value);
            }
            return this;
        }
    }

    public static class PluginInfo {
        public String name;
        public String url;
        public boolean mandatory;
        public boolean loaded;
        public boolean update;

        public PluginInfo(String name, String url, boolean mandatory) {
            this.name = name;
            this.url = url;
            this.mandatory = mandatory;
        }
    }
}

