/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import misc.ProgressState;
import misc.Util;

public class ProgressStatePanel
extends JPanel
implements ActionListener {
    JProgressBar jProgressBar = new JProgressBar();
    JButton stopButton = new JButton(Util.loadActionIcon("Abort"));
    ProgressState progressState;

    public ProgressStatePanel(ProgressState progressState) {
        this.progressState = progressState;
        this.jProgressBar.setMaximum(1);
        this.jProgressBar.setString("");
        this.jProgressBar.setStringPainted(true);
        this.jProgressBar.setAlignmentX(0.0f);
        this.setLayout(new BorderLayout());
        this.add((Component)this.jProgressBar, "Center");
        this.stopButton.setActionCommand("Abort");
        this.stopButton.addActionListener(this);
        this.stopButton.setEnabled(false);
        this.add((Component)this.stopButton, "After");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() != this.stopButton) {
            return;
        }
        this.progressState.abort();
    }

    public void updateProgress() {
        switch (this.progressState.state) {
            case Value: {
                this.jProgressBar.setValue(this.progressState.value);
                break;
            }
            case Init: {
                this.jProgressBar.setString(this.progressState.domain);
                this.jProgressBar.setValue(this.progressState.value);
                this.jProgressBar.setMaximum(this.progressState.maxValue);
                this.stopButton.setEnabled(true);
                break;
            }
            case End: {
                this.jProgressBar.setString("");
                this.jProgressBar.setValue(0);
                this.stopButton.setEnabled(false);
            }
        }
    }
}

