/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.net.ProxySelector;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import misc.ApplicationManager;
import misc.Bundle;
import misc.Config;
import misc.OwnFrame;
import misc.Util;

public class ProxyManager
implements ApplicationManager,
ActionListener {
    public static final String actionSetProxy = "SetProxy";
    public static final String actionNoProxy = "NoProxy";
    public static final String actionSystemConfigProxy = "SystemConfigProxy";
    public static final String actionManualConfigProxy = "ManualConfigProxy";
    public static final List<String> radioButtonNames = Arrays.asList("NoProxy", "SystemConfigProxy", "ManualConfigProxy");
    public static final List<String> actionsNames = Arrays.asList("SetProxy");
    public static final Hashtable<String, Method> actionsMethod = Util.collectMethod(ProxyManager.class, actionsNames, radioButtonNames);
    JPanel manualPanel;
    private OwnFrame controller;

    @Override
    public void actionPerformed(ActionEvent e) {
        Util.actionPerformed(actionsMethod, e, this);
    }

    @Override
    public void addMenuItem(JMenu ... jMenu) {
        Util.addMenuItem(actionsNames, (ActionListener)this, (Container)jMenu[0]);
    }

    @Override
    public void addIconButtons(Container ... containers) {
        Util.addIconButton(actionsNames, (ActionListener)this, containers[0]);
    }

    @Override
    public void addActiveButtons(Hashtable<String, AbstractButton> buttons) {
    }

    private String getConfig() {
        if ("true".equals(System.getProperty("java.net.useSystemProxies"))) {
            return actionSystemConfigProxy;
        }
        String host = System.getProperty("http.proxyHost");
        String port = System.getProperty("http.proxyPort");
        if (host == null || port == null || host.isEmpty() || port.isEmpty()) {
            return actionNoProxy;
        }
        return actionManualConfigProxy;
    }

    public void actionSetProxy() {
        JFrame jFrame = new JFrame();
        jFrame.setIconImage(this.controller.getIcon());
        JPanel msgPanel = Util.getGridBagPanel();
        String proxyConfig = this.getConfig();
        ButtonGroup group = new ButtonGroup();
        Util.addRadioButton(actionNoProxy, this, group, proxyConfig, msgPanel, Util.GBCNL);
        Util.addRadioButton(actionSystemConfigProxy, this, group, proxyConfig, msgPanel, Util.GBCNL);
        Util.addRadioButton(actionManualConfigProxy, this, group, proxyConfig, msgPanel, Util.GBCNL);
        this.manualPanel = Util.getGridBagPanel();
        JTextField hostTF = new JTextField(Config.getString("ProxyHostName", "squid"), 18);
        JTextField portTF = new JTextField(Config.getString("ProxyPort", "3128"), 6);
        Util.addLabelFields(this.manualPanel, "Host", hostTF);
        Util.addLabelFields(this.manualPanel, "Port", portTF);
        Util.addComponent(this.manualPanel, msgPanel, Util.GBCNL);
        Util.setEnabled(this.manualPanel, proxyConfig.equals(actionManualConfigProxy));
        if (JOptionPane.showConfirmDialog(jFrame, msgPanel, Bundle.getTitle("Proxy"), 0) != 0) {
            return;
        }
        Config.setString("ProxyHostName", hostTF.getText());
        Config.setString("ProxyPort", portTF.getText());
        proxyConfig = group.getSelection().getActionCommand();
        if (actionSystemConfigProxy.equals(proxyConfig)) {
            System.setProperty("java.net.useSystemProxies", "true");
            System.setProperty("http.proxyHost", "");
        } else {
            System.setProperty("java.net.useSystemProxies", "false");
            if (actionNoProxy.equals(proxyConfig)) {
                System.setProperty("http.proxyHost", "");
            } else if (actionManualConfigProxy.equals(proxyConfig)) {
                System.setProperty("http.proxyHost", hostTF.getText());
                System.setProperty("http.proxyPort", portTF.getText());
            }
        }
        ProxySelector.setDefault(ProxySelector.getDefault());
    }

    public void actionNoProxy() {
        Util.setEnabled(this.manualPanel, false);
    }

    public void actionSystemConfigProxy() {
        Util.setEnabled(this.manualPanel, false);
    }

    public void actionManualConfigProxy() {
        Util.setEnabled(this.manualPanel, true);
    }

    public ProxyManager(OwnFrame controller) {
        this.controller = controller;
    }
}

