/*
 * Decompiled with CFR 0.152.
 */
package misc;

import misc.NewChalenger;

public class RealTime {
    private int nbChalengers;
    private Thread leadership;

    public void start(final Runnable task) {
        new Thread(){

            @Override
            public void run() {
                if (!RealTime.this.getLeadership()) {
                    return;
                }
                try {
                    task.run();
                }
                catch (NewChalenger newChalenger) {
                }
                finally {
                    RealTime.this.loseLeaderShip();
                }
            }
        }.start();
    }

    public synchronized void waitTerminaison() {
        if (this.leadership == Thread.currentThread()) {
            return;
        }
        while (this.leadership != null && this.nbChalengers > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized boolean getLeadership() {
        if (this.leadership != null) {
            ++this.nbChalengers;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            --this.nbChalengers;
            if (this.nbChalengers != 0) {
                this.notifyAll();
                return false;
            }
        }
        this.leadership = Thread.currentThread();
        return true;
    }

    public synchronized void loseLeaderShip() {
        this.leadership = null;
        this.notifyAll();
    }

    public synchronized void checkChalengers() {
        if (this.nbChalengers != 0) {
            throw new NewChalenger();
        }
    }

    public static void checkChalengers(RealTime realTime) {
        if (realTime != null) {
            realTime.checkChalengers();
        }
    }
}

