/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.TreeSet;
import misc.Log;

public class StateNotifier {
    private Hashtable<Object, TreeSet<String>> observers = new Hashtable();
    private Hashtable<String, Hashtable<Object, Method>> observableNames = new Hashtable();

    private void broadcast(String observable) {
        Hashtable<Object, Method> objectMethod = this.observableNames.get(observable);
        if (objectMethod == null) {
            return;
        }
        try {
            for (Object object : objectMethod.keySet()) {
                objectMethod.get(object).invoke(object, new Object[0]);
            }
        }
        catch (Exception e) {
            Log.keepLastException("ModelInfoSender::broadcast <" + observable + ">", e);
        }
    }

    private void broadcast(String observable, Object ... args) {
        Hashtable<Object, Method> objectMethod = this.observableNames.get(observable);
        if (objectMethod == null) {
            return;
        }
        try {
            for (Object object : objectMethod.keySet()) {
                objectMethod.get(object).invoke(object, new Object[]{args});
            }
        }
        catch (Exception e) {
            Log.keepLastException("ModelInfoSender::broadcast <" + observable + ">", e);
        }
    }

    public void broadcastUpdate(String observable) {
        this.broadcast("update" + observable);
    }

    public void broadcastDisplay(String observable, Object ... args) {
        this.broadcast("display" + observable, args);
    }

    private void addObserver(Object object, boolean arg, String ... observable) {
        TreeSet<String> newNames = new TreeSet<String>();
        for (String obs : observable) {
            String name = (arg ? "display" : "update") + obs;
            try {
                Method method = arg ? object.getClass().getMethod(name, Object[].class) : object.getClass().getMethod(name, new Class[0]);
                Hashtable<Object, Method> objectMethod = this.observableNames.get(name);
                if (objectMethod == null) {
                    objectMethod = new Hashtable();
                    this.observableNames.put(name, objectMethod);
                }
                objectMethod.put(object, method);
                newNames.add(name);
            }
            catch (NoSuchMethodException e) {
                Log.keepLastException("StateNotifier::addObserver no method <" + name + "> in class <" + object.getClass() + ">", e);
            }
        }
        if (newNames.size() == 0) {
            return;
        }
        try {
            TreeSet<String> oldNames = this.observers.get(object);
            oldNames.addAll(newNames);
        }
        catch (Exception e) {
            this.observers.put(object, newNames);
        }
    }

    public void addUpdateObserver(Object object, String ... observable) {
        this.addObserver(object, false, observable);
    }

    public void addMsgObserver(Object object, String ... observable) {
        this.addObserver(object, true, observable);
    }

    public void removeObserver(Object object) {
        TreeSet<String> names = this.observers.get(object);
        if (names == null) {
            return;
        }
        for (String name : names) {
            Hashtable<Object, Method> objectMethod = this.observableNames.get(name);
            objectMethod.remove(object);
            if (objectMethod.size() != 0) continue;
            this.observableNames.remove(name);
        }
        this.observers.remove(object);
    }
}

