/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.util.ArrayList;
import java.util.Stack;
import java.util.Vector;
import misc.StateNotifier;

public class Story {
    public static final String BroadcastStory = "Story";
    StateNotifier observable;
    Stack<Command> undo = new Stack();
    Stack<Command> redo = new Stack();
    Command lastSaved;

    public Vector<String> getUndoCmd() {
        return this.getCmd(this.undo);
    }

    public Vector<String> getRedoCmd() {
        return this.getCmd(this.redo);
    }

    public Vector<String> getCmd(Stack<Command> commands) {
        Vector<String> result = new Vector<String>(commands.size());
        for (int i = commands.size() - 1; i >= 0; --i) {
            result.add(((Command)commands.get((int)i)).name);
        }
        return result;
    }

    public Story(StateNotifier observable) {
        this.observable = observable;
    }

    public void addUpdateObserver(Object object) {
        this.observable.addUpdateObserver(object, BroadcastStory);
    }

    public void removeObserver(Object object) {
        this.observable.removeObserver(object);
    }

    public void add(Command command) {
        try {
            if (command instanceof Commands && ((Commands)command).commands.size() < 1) {
                return;
            }
            command.exec();
            command.displayExec();
            this.undo.push(command);
        }
        finally {
            this.redo.clear();
            this.observable.broadcastUpdate(BroadcastStory);
        }
    }

    Command lastCommand() {
        return this.undo.empty() ? null : this.undo.peek();
    }

    public void markNotSaved() {
        this.lastSaved = new Command(""){

            @Override
            public void exec() {
            }

            @Override
            public void undo() {
            }
        };
        this.observable.broadcastUpdate(BroadcastStory);
    }

    public void markSaved() {
        this.lastSaved = this.lastCommand();
        this.observable.broadcastUpdate(BroadcastStory);
    }

    public boolean isModified() {
        return this.lastSaved != this.lastCommand();
    }

    public boolean undoAvailable() {
        return !this.undo.empty();
    }

    public boolean redoAvailable() {
        return !this.redo.empty();
    }

    public ArrayList<String> getUndoCommande() {
        return this.getString(this.undo);
    }

    public ArrayList<String> getRedoCommande() {
        return this.getString(this.redo);
    }

    ArrayList<String> getString(Stack<Command> stack) {
        ArrayList<String> result = new ArrayList<String>();
        for (Command command : stack) {
            result.add(command.name);
        }
        return result;
    }

    public void undo(int level) {
        try {
            for (int i = 0; i < level; ++i) {
                Command command = this.undo.pop();
                command.undo();
                command.displayUndo();
                this.redo.push(command);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.observable.broadcastUpdate(BroadcastStory);
    }

    public void redo(int level) {
        try {
            for (int i = 0; i < level; ++i) {
                Command command = this.redo.pop();
                command.exec();
                command.displayExec();
                this.undo.push(command);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.observable.broadcastUpdate(BroadcastStory);
    }

    public abstract class Commands
    extends Command {
        ArrayList<Command> commands;

        public Commands(String name) {
            super(name);
            this.commands = new ArrayList();
        }

        public Story getStory() {
            return Story.this;
        }

        public int size() {
            return this.commands.size();
        }

        public void add(Command command) {
            this.commands.add(command);
        }

        @Override
        public void exec() {
            for (Command command : this.commands) {
                command.exec();
                command.displayExec();
            }
        }

        @Override
        public void undo() {
            for (int i = this.commands.size() - 1; i >= 0; --i) {
                Command command = this.commands.get(i);
                command.undo();
                command.displayUndo();
            }
        }

        public String toString() {
            String result = "";
            for (Command command : this.commands) {
                result = result + " " + command.name;
            }
            return result;
        }
    }

    public abstract class Command {
        public final String name;

        public Command(String name) {
            this.name = name;
        }

        public abstract void exec();

        public abstract void undo();

        public void displayExec() {
            this.display();
        }

        public void displayUndo() {
            this.display();
        }

        public void display() {
        }
    }
}

