/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.TimeZone;

public class Timer {
    public static SimpleDateFormat sdf = new SimpleDateFormat("H:mm:ss.S");
    long start;
    long lastEnd;
    ArrayList<Milestone> milestones;

    public Timer() {
        this.lastEnd = this.start = System.currentTimeMillis();
        this.milestones = new ArrayList();
    }

    public String getLap(String milestoneName) {
        long now = System.currentTimeMillis();
        long end = now - this.start;
        long last = now - this.lastEnd;
        this.lastEnd = now;
        this.milestones.add(new Milestone(milestoneName, end, last));
        return milestoneName + ": " + sdf.format(end) + " (" + end + "): " + sdf.format(last) + " (" + last + ")";
    }

    public String getNames() {
        String result = "";
        for (Milestone milestone : this.milestones) {
            result = result + ":" + milestone.name;
        }
        return result;
    }

    public String getEnds() {
        String result = "";
        for (Milestone milestone : this.milestones) {
            result = result + ":" + sdf.format(milestone.end) + " (" + milestone.end + ")";
        }
        return result;
    }

    public String getLasts() {
        String result = "";
        for (Milestone milestone : this.milestones) {
            result = result + ":" + sdf.format(milestone.last) + " (" + milestone.last + ")";
        }
        return result;
    }

    static {
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    class Milestone {
        String name;
        long end;
        long last;

        Milestone(String name, long end, long last) {
            this.name = name;
            this.end = end;
            this.last = last;
        }
    }
}

