/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingConstants;
import misc.Bundle;
import misc.Config;
import misc.Util;

public class TitledDialog
extends JDialog
implements SwingConstants {
    protected String titleId;

    public TitledDialog(Frame frame, final String titleId) {
        super(frame, Bundle.getTitle(titleId), false);
        this.titleId = titleId;
        Bundle.addLocalizedDialog(this, titleId);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Util.updateCheckBox(titleId, false);
            }
        });
        boolean visible = Config.getBoolean(titleId + "Checked", false);
        this.setVisible(visible);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        Util.updateCheckBox(this.titleId, visible);
        if (visible) {
            this.pack();
            this.setLocationRelativeTo(null);
            Config.loadLocation(this.titleId, this, this.getLocation());
            this.toFront();
        } else {
            this.saveLocation();
        }
    }

    public void setJFrame(JFrame jFrame) {
        this.setIconImage(jFrame.getIconImage());
    }

    public void saveLocation() {
        Config.saveLocation(this.titleId, this);
    }
}

