/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.awt.Frame;
import java.text.ParsePosition;
import java.util.Locale;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import misc.Bundle;
import misc.Config;
import misc.TitledDialog;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.runner.JUnitCore;

public class TitledDialogTest
extends Assert {
    public static TitledDialog titledDialog;

    public static Test suite() {
        return new JUnit4TestAdapter(TitledDialogTest.class);
    }

    public static void main(String[] args) {
        JUnitCore.main((String[])new String[]{"misc.TitledDialogTest"});
    }

    @BeforeClass
    public static void setBundleObserver() {
        Bundle.load("BundleManager");
        titledDialog = new TitledDialog(new Frame(), "BundleEditor");
    }

    @org.junit.Test
    public void bundleReloaded() {
        Bundle.load("BundleManager", Locale.US);
        String s1 = titledDialog.getTitle();
        Bundle.setLocale(Locale.FRANCE);
        String s2 = titledDialog.getTitle();
        TitledDialogTest.assertNotNull((Object)s1);
        TitledDialogTest.assertNotNull((Object)s2);
        TitledDialogTest.assertFalse((boolean)s1.equals(s2));
    }

    @org.junit.Test
    public void setVisible() {
        Config.setPWD(TitledDialogTest.class);
        Config.load("BundleManager");
        titledDialog.setVisible(true);
        TitledDialogTest.assertTrue((boolean)titledDialog.isVisible());
        titledDialog.setVisible(false);
        TitledDialogTest.assertFalse((boolean)titledDialog.isVisible());
    }

    @org.junit.Test
    public void saveLocation() {
        Config.setPWD(TitledDialogTest.class);
        Config.load("BundleManager");
        TitledDialogTest.assertNull((Object)Config.getString("BundleEditorLocation", null));
        titledDialog.setVisible(true);
        titledDialog.setVisible(false);
        titledDialog.saveLocation();
        Object[] location = Config.coordonateFormat.parse(Config.getString("BundleEditorLocation", null), new ParsePosition(0));
        TitledDialogTest.assertTrue((((Number)location[0]).intValue() > 0 ? 1 : 0) != 0);
        TitledDialogTest.assertTrue((((Number)location[1]).intValue() > 0 ? 1 : 0) != 0);
    }
}

