/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import misc.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class XML {
    public static Document readDocument(InputStream stream) throws IOException {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(new NoWaittingNoCloseInputStream(stream));
            document.normalizeDocument();
            return document;
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }

    public static void writeDocument(Document document, OutputStream stream) {
        try {
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(stream);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.setOutputProperty("indent", "yes");
            xformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            xformer.transform(source, result);
            stream.write("\n".getBytes());
            stream.flush();
        }
        catch (Exception e) {
            Log.keepLastException("XML::writeDocument", e);
        }
    }

    public static void writeElement(Element element, OutputStream stream) {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            document.setXmlStandalone(true);
            document.appendChild(document.importNode(element, true));
            XML.writeDocument(document, stream);
            stream.flush();
        }
        catch (Exception e) {
            Log.keepLastException("XML::writeElement", e);
        }
    }

    public static final void putToken(Hashtable<String, String> hashtable, String token, String value) {
        hashtable.put(token, value == null ? "" : value);
    }

    public static final Hashtable<String, String> node2hashtable(Node child) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        while (child != null) {
            if (child.getNodeType() == 1) {
                Element elementTag = (Element)child;
                String token = child.getNodeName();
                NodeList nodeList = ((Element)child).getChildNodes();
                if (nodeList.getLength() > 0) {
                    hashtable.put(token, ((Text)nodeList.item(0)).getWholeText());
                }
            }
            child = child.getNextSibling();
        }
        return hashtable;
    }

    public static final void hashtable2node(Document document, Element container, Hashtable<String, String> hashtable) {
        for (String token : hashtable.keySet()) {
            Element tag = document.createElement(token);
            tag.appendChild(document.createTextNode(hashtable.get(token)));
            container.appendChild(tag);
        }
    }

    public static class NoWaittingNoCloseInputStream
    extends FilterInputStream {
        public NoWaittingNoCloseInputStream(InputStream in) {
            super(in);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (super.available() <= 0) {
                return -1;
            }
            int nb = super.read(b, off, len);
            return nb;
        }

        @Override
        public void close() throws IOException {
        }
    }
}

