/*
 * Decompiled with CFR 0.152.
 */
package tp6.control;

import misc.Bundle;
import misc.Config;
import misc.Util;
import tp6.control.Test;
import tp6.model.Game;
import tp6.model.ICom;
import tp6.model.NetCom;
import tp6.model.TxtCom;
import tp6.view.JAddPlayer;
import tp6.view.JGame;

public class Launch {
    public static void main(String[] args) {
        if (args.length != 3 && args.length != 4) {
            System.err.println("usage: java RomancierScilof <-net|-txt> <name> <port> [<avatar>]");
            System.exit(1);
        }
        boolean netMode = "-net".equals(args[0]);
        String name = args[1];
        int port = Integer.parseInt(args[2]);
        String avatar = "";
        if (args.length == 4) {
            avatar = args[3];
        }
        Config.setPWD(Test.class);
        Config.load("RomancierScilof");
        Bundle.load("Help");
        Bundle.load("ToolBar");
        Bundle.load("Controller");
        Bundle.load("RomancierScilof");
        Game game = new Game(port);
        TxtCom txtCom = new TxtCom(game);
        if (netMode) {
            try {
                NetCom netCom = new NetCom(game, port);
                System.err.println("RomancierScilof start on " + game.getLocalHost() + ":" + port);
                game.setCom((ICom)netCom);
            }
            catch (Exception e) {
                System.err.println("Can't start on " + game.getLocalHost() + ":" + port);
                System.exit(1);
            }
        } else {
            game.setCom(txtCom);
        }
        game.setPlayer(name, avatar);
        JGame jGame = new JGame(game);
        JAddPlayer jAddPlayer = new JAddPlayer(game, game.getLocalHost());
        Util.newJFrame("RomancierScilof", jGame, true);
        Util.newJFrame("Control", jAddPlayer, true);
    }
}

