/*
 * Decompiled with CFR 0.152.
 */
package tp6.model;

import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tp6.model.ICom;
import tp6.model.IGame;
import tp6.model.Letter;
import tp6.model.Player;
import tp6.model.Proposal;

public class GameReceived {
    private IGame game;
    static Pattern AvatarArgPattern = Pattern.compile("\\s*(.*)\\s*");
    static Pattern playerArgPattern = Pattern.compile("\\s*(\\p{Alpha}\\w*)@(\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}):(\\d{1,5})\\s*");
    static Pattern letterArgPattern = Pattern.compile("\\s*(\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}):(\\d{1,5})-([A-Z])\\s*");
    static Pattern lettersArgPattern = Pattern.compile("\\s*(\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}):(\\d{1,5})-([A-Z]|\\[[A-Z]+\\])\\s*");

    public GameReceived(IGame game) {
        this.game = game;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveMsg(ICom.Packet packet) {
        Matcher m;
        boolean b;
        String ip = packet.ip;
        int port = packet.port;
        String line = packet.msg;
        ParsePosition pos = new ParsePosition(0);
        Date date = ICom.sdfl.parse(line, pos);
        if (pos.getErrorIndex() < 0) {
            line = line.substring(pos.getIndex());
        }
        if (!(b = (m = ICom.msgPattern.matcher(line)).matches())) {
            System.err.println("GNP: Can't parse " + line);
            return;
        }
        IGame iGame = this.game;
        synchronized (iGame) {
            Player sender = this.game.findNewPlayer(m.group(1), ip, port);
            String cmd = m.group(2);
            String arg = m.group(3);
            if (ICom.cmdsWithoutArg.contains(cmd)) {
                this.execNoArg(sender, cmd);
            } else if (ICom.cmdsWithString.contains(cmd)) {
                this.execStringArg(sender, date, arg);
            } else if (ICom.cmdsWithPlayers.contains(cmd)) {
                this.execPlayersArg(sender, cmd, arg);
            } else if (ICom.cmdsWithLetter.contains(cmd)) {
                this.execLetterArg(sender, cmd, arg);
            } else if (ICom.cmdsWithLetters.contains(cmd)) {
                this.execLettersArg(sender, cmd, arg);
            } else if (ICom.cmdsWithAvatar.contains(cmd)) {
                this.execAvatarArg(sender, cmd, arg);
            } else {
                System.err.println("GameReceived: unknown command :" + cmd);
            }
        }
    }

    public void execNoArg(Player sender, String cmd) {
        if ("hereIam".equals(cmd)) {
            this.game.addKnownedPlayer(sender);
        } else if ("guest".equals(cmd)) {
            this.game.addGuesting(sender);
        } else if ("close".equals(cmd)) {
            this.game.rcvClose();
        } else if ("full".equals(cmd)) {
            this.game.rcvFull();
        } else {
            System.err.println("TODO execNoArg");
        }
    }

    public void execStringArg(Player sender, Date date, String arg) {
        System.err.println("TODO execStringArg");
    }

    public void execPlayersArg(Player sender, String cmd, String arg) {
        Matcher m = playerArgPattern.matcher(arg);
        ArrayList<Player> players = new ArrayList<Player>();
        while (m.find()) {
            players.add(this.game.findNewPlayer(m.group(1), m.group(2), Integer.parseInt(m.group(3))));
        }
        if (players.size() <= 0) {
            return;
        }
        if ("declare".equals(cmd)) {
            this.game.addKnownedPlayers(players);
        } else if ("welcome".equals(cmd)) {
            this.game.addPlayers(players);
        }
    }

    public void execLetterArg(Player sender, String cmd, String arg) {
        Matcher m = letterArgPattern.matcher(arg);
        if (!m.matches()) {
            return;
        }
        Letter letter = new Letter(m.group(3), m.group(1), m.group(2));
        if ("send".equals(cmd)) {
            this.game.addProposal(new Proposal(this.game, sender, letter));
        } else if ("answer".equals(cmd)) {
            this.game.giveLetter(letter);
        } else if ("reject".equals(cmd)) {
            this.game.giveLetter(letter);
        }
    }

    public void execLettersArg(Player sender, String cmd, String arg) {
        Matcher m = lettersArgPattern.matcher(arg);
        ArrayList<Letter> letters = new ArrayList<Letter>();
        block4: while (m.find()) {
            switch (m.group(3).length()) {
                case 0: {
                    continue block4;
                }
                case 1: {
                    letters.add(new Letter(m.group(3), m.group(1), m.group(2)));
                    continue block4;
                }
            }
            for (int i = 1; i < m.group(3).length() - 1; ++i) {
                letters.add(new Letter(m.group(3).substring(i, i + 1), m.group(1), m.group(2)));
            }
        }
        this.game.checkScore(sender, letters);
    }

    public void execAvatarArg(Player sender, String cmd, String arg) {
        this.game.setAvatar(sender, arg);
    }
}

