/*
 * Decompiled with CFR 0.152.
 */
package tp6.model;

import java.util.Hashtable;
import java.util.List;
import java.util.TreeSet;
import tp6.model.Player;

public class Letter {
    private String alpha;
    private String ip;
    private int port;

    public String getAlpha() {
        return this.alpha;
    }

    public Player getPlayer() {
        return new Player(null, this.ip, this.port);
    }

    public Letter(String alpha, String ip, int port) {
        this.alpha = alpha;
        this.ip = ip;
        this.port = port;
    }

    public Letter(String alpha, String ip, String port) {
        this(alpha, ip, Integer.parseInt(port));
    }

    public Letter(String alpha, Player player) {
        this(alpha, player.getIp(), player.getPort());
    }

    public String toString() {
        return this.ip + ":" + this.port + "-" + this.alpha;
    }

    public static String toString(List<Letter> letters) {
        Hashtable<String, TreeSet<String>> hostLetter = new Hashtable<String, TreeSet<String>>();
        for (Letter letter : letters) {
            String host = letter.ip + ":" + letter.port;
            TreeSet<String> alphas = (TreeSet<String>)hostLetter.get(host);
            if (alphas == null) {
                alphas = new TreeSet<String>();
                hostLetter.put(host, alphas);
            }
            alphas.add(letter.alpha);
        }
        String result = "";
        String sep = "";
        for (String host : hostLetter.keySet()) {
            result = result + sep + host + "-[";
            for (String alpha : (TreeSet)hostLetter.get(host)) {
                result = result + alpha;
            }
            result = result + "]";
            sep = " ";
        }
        return result;
    }
}

