/*
 * Decompiled with CFR 0.152.
 */
package tp6.model;

import java.awt.Color;
import javax.swing.ImageIcon;
import tp6.model.IGame;
import tp6.model.Letter;
import tp6.model.Player;

public class Proposal {
    public static final int maxSecond = 10;
    public static final int nbStepSeconde = 4;
    public static final int nbStep = 40;
    public static final Color[] colors = new Color[40];
    private Player player;
    private Letter letter;
    private long creationTime;

    public Player getPlayer() {
        return this.player;
    }

    public Letter getLetter() {
        return this.letter;
    }

    public String getPlayerName() {
        return this.player.getName();
    }

    public ImageIcon getPlayerHalfIcon() {
        return this.player.getHalfIcon();
    }

    public Proposal(final IGame game, Player player, Letter letter) {
        this.player = player;
        this.letter = letter;
        this.creationTime = System.currentTimeMillis();
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    1.sleep(10000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                IGame iGame = game;
                synchronized (iGame) {
                    game.rejectLetter(Proposal.this);
                }
            }
        }.start();
    }

    public Color getColor() {
        return colors[Math.min(39, (int)((System.currentTimeMillis() - this.creationTime) * 40L / 10000L))];
    }

    public String toString() {
        return this.player + "-" + this.letter;
    }

    static {
        float gray = 0.92f;
        for (int i = 0; i < 40; ++i) {
            Proposal.colors[i] = Color.getHSBColor(0.0f, (float)i / 40.0f, gray + (1.0f - gray) * (float)i / 40.0f);
        }
    }
}

