/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.border.TitledBorder;
import misc.Config;
import misc.HelpManager;
import misc.StateNotifier;
import misc.Util;

public class Bundle {
    public static final String FS = System.getProperty("file.separator");
    public static final String bundleExt = ".properties";
    public static final String titlePostfix = "Title";
    public static final String actionPrefix = "Action";
    public static final String labelPrefix = "Label";
    public static final String storyPrefix = "Story";
    public static final String messagePrefix = "Message";
    public static final String exceptionPrefix = "Exception";
    public static final String userPrefix = "User_";
    public static final String enumPrefix = "Enum";
    private static final String bundleUseException = "Can''t find token \"{0}\" in Bundle. Continue?";
    private static final String bundleSaveException = "Bundle {0} can''t be save.";
    private static Hashtable<String, String> labels = new Hashtable();
    private static Hashtable<String, ApplicationInfo> applications = new Hashtable();
    private static ArrayList<String> applicationsOrder = new ArrayList();
    private static Locale locale;
    static ResourceBundle.Control bundleControl;
    private static boolean configurationModified;
    public static boolean askBundleUseException;
    private static Vector<AbstractButton> allActioners;
    private static Vector<AbstractButton> allMenus;
    private static Hashtable<Dialog, String> allDialogs;
    private static Vector<AbstractButton> allIconToolTips;
    private static Hashtable<JLabel, String> allLabels;
    private static Hashtable<JComboBox<String>, Class<?>> allEnums;
    private static StateNotifier bundleObservable;

    public static Locale getLocale() {
        return locale;
    }

    public static void setLocale(Locale locale) {
        Bundle.resetLocale(locale);
        Bundle.broadcastBundleReloaded();
    }

    private static final void initLocale() {
        if (locale != null) {
            return;
        }
        Locale locale = Locale.getDefault();
        if (Config.getString("Language") != null) {
            try {
                locale = new Locale(Config.getString("Language"), Config.getString("Country"), Config.getString("Variant"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Bundle.resetLocale(locale);
    }

    private static void resetLocale(Locale locale) {
        if (Bundle.locale == locale || Bundle.locale != null && Bundle.locale.equals(locale)) {
            return;
        }
        Locale.setDefault(locale);
        Bundle.locale = locale;
        for (String application : applicationsOrder) {
            ResourceBundle messages = ResourceBundle.getBundle(application, locale, bundleControl);
            applications.put(application, new ApplicationInfo(messages));
        }
    }

    public static final void load(String application) {
        Bundle.initLocale();
        Bundle.load(application, locale);
    }

    public static final void load(String application, Locale locale) {
        block5: {
            try {
                Bundle.resetLocale(locale);
                if (applicationsOrder.contains(application)) {
                    return;
                }
                applicationsOrder.add(application);
                ResourceBundle messages = ResourceBundle.getBundle(application, locale, bundleControl);
                applications.put(application, new ApplicationInfo(messages));
                for (String key : messages.keySet()) {
                    labels.put(key, application);
                }
                boolean needSetLanguage = Config.getString("Language") == null;
                Bundle.broadcastBundleReloaded();
                if (needSetLanguage) {
                    HelpManager.actionLocale(null);
                }
            }
            catch (RuntimeException e) {
                if (0 == JOptionPane.showConfirmDialog(null, "Would you like to continue?", " Can't load Bundle " + application, 0)) break block5;
                throw e;
            }
        }
    }

    public static final void save(String applicationName) {
        File configDir = new File(Config.findDataDir(true), "config");
        File bundleFile = new File(configDir, applicationName + "_" + locale + bundleExt);
        try {
            Bundle.save(applicationName, bundleFile);
        }
        catch (IOException e) {
            try {
                configDir.mkdirs();
                Bundle.save(applicationName, bundleFile);
            }
            catch (IOException e2) {
                System.err.println(MessageFormat.format(bundleSaveException, applicationName));
            }
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException(bundleUseException);
        }
    }

    public static final void save(String applicationName, File file) throws IOException {
        ApplicationInfo applicationInfo = applications.get(applicationName);
        if (!applicationInfo.modified && file.exists()) {
            return;
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        Properties properties = new Properties();
        ResourceBundle messages = applicationInfo.messages;
        for (String string : messages.keySet()) {
            properties.setProperty(string, messages.getString(string));
        }
        Hashtable<String, String> patch = applicationInfo.patch;
        for (String key : patch.keySet()) {
            properties.setProperty(key, patch.get(key));
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        properties.store(fileOutputStream, "Produit automatiquement par Bundle");
        fileOutputStream.close();
        FileInputStream fileInputStream = new FileInputStream(file);
        applicationInfo.messages = new PropertyResourceBundle(fileInputStream);
        fileInputStream.close();
        applicationInfo.patch.clear();
        applicationInfo.modified = false;
    }

    public static void setString(String applicationName, String key, String val) {
        ApplicationInfo applicationInfo = applications.get(applicationName);
        String oldVal = null;
        try {
            oldVal = applicationInfo.messages.getString(key);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (val == oldVal || val.equals(oldVal)) {
            applicationInfo.patch.remove(key);
            return;
        }
        oldVal = applicationInfo.patch.get(key);
        if (val == oldVal || val.equals(oldVal)) {
            return;
        }
        applicationInfo.patch.put(key, val);
        applicationInfo.modified = true;
        labels.put(key, applicationName);
    }

    public static final Locale[] getApplicationsLocales() {
        Vector<Locale> result = new Vector<Locale>();
        block0: for (Locale locale : Bundle.getAvailableLocales()) {
            for (String application : applications.keySet()) {
                if (ClassLoader.getSystemResource(Config.configSystemDir + application + "_" + locale + bundleExt) != null || ClassLoader.getSystemResource("data/config/" + application + "_" + locale + bundleExt) != null) continue;
                continue block0;
            }
            result.add(locale);
        }
        Locale[] locales = result.toArray(new Locale[0]);
        Arrays.sort(locales, new Comparator<Locale>(){

            @Override
            public int compare(Locale o1, Locale o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        return locales;
    }

    public static Locale[] getAvailableLocales() {
        ArrayList<Locale> all = new ArrayList<Locale>(Arrays.asList(Locale.getAvailableLocales()));
        all.add(new Locale.Builder().setLanguage("br").setRegion("FR").setVariant("gallo").build());
        all.add(new Locale.Builder().setLanguage("br").setRegion("FR").setVariant("breton").build());
        return all.toArray(new Locale[0]);
    }

    public static final Locale[] getAllLocales() {
        Locale[] locales = Bundle.getAvailableLocales();
        Arrays.sort(locales, new Comparator<Locale>(){

            @Override
            public int compare(Locale o1, Locale o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        return locales;
    }

    public static ImageIcon getMixFlag(String language, String country) {
        ImageIcon countryFlag = Util.loadImageIcon("data", "images", "flags", country.toLowerCase() + ".png");
        ImageIcon langFlag = Util.loadImageIcon("data", "images", "flags", language.toLowerCase() + ".png");
        if (countryFlag == null) {
            return langFlag;
        }
        if (langFlag == null) {
            return countryFlag;
        }
        int width = countryFlag.getIconWidth();
        int height = countryFlag.getIconHeight();
        BufferedImage newFlag = new BufferedImage(width, height, 2);
        Graphics2D g2 = newFlag.createGraphics();
        Polygon topLeftCorner = new Polygon(new int[]{0, width, 0}, new int[]{0, 0, height}, 3);
        g2.setClip(topLeftCorner);
        g2.drawImage(langFlag.getImage(), 0, 0, width, height, null);
        Polygon bottomRightCorner = new Polygon(new int[]{0, width, width}, new int[]{height, 0, height}, 3);
        g2.setClip(bottomRightCorner);
        g2.drawImage(countryFlag.getImage(), 0, 0, width, height, null);
        return new ImageIcon(newFlag);
    }

    public static final JComboBox<String> getJComboFlags(final Locale[] locales) {
        final ImageIcon[] flags = new ImageIcon[locales.length];
        String[] labels = new String[locales.length];
        final Hashtable<String, Integer> labelIndex = new Hashtable<String, Integer>();
        for (int i = 0; i < locales.length; ++i) {
            labels[i] = locales[i].toString();
            labelIndex.put(labels[i], i);
            flags[i] = Bundle.getMixFlag(locales[i].getLanguage(), locales[i].getCountry());
            if (flags[i] == null) continue;
            flags[i].setDescription(locales[i].toString());
        }
        JComboBox<String> localesList = new JComboBox<String>(labels);
        localesList.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;
            {
                this.setOpaque(true);
                this.setVerticalAlignment(0);
            }

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                int selectedIndex = (Integer)labelIndex.get(value);
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                    this.setForeground(list.getSelectionForeground());
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
                this.setIcon(flags[selectedIndex]);
                this.setText(locales[selectedIndex].toString());
                return this;
            }
        });
        return localesList;
    }

    public static final String getString(String messageId, String defaultValue) {
        try {
            ApplicationInfo applicationInfo = applications.get(labels.get(messageId));
            String val = applicationInfo.patch.get(messageId);
            if (val != null) {
                return val;
            }
            return applicationInfo.messages.getString(messageId);
        }
        catch (Exception e) {
            if (defaultValue != null) {
                return defaultValue;
            }
            if (askBundleUseException && 0 != JOptionPane.showConfirmDialog(null, MessageFormat.format(bundleUseException, messageId), " Bundle corrupted ", 0)) {
                throw new IllegalArgumentException(MessageFormat.format(bundleUseException, messageId));
            }
            askBundleUseException = false;
            System.err.println(messageId + "= ### Bundle ###");
            return messageId;
        }
    }

    public static final String getStory(String messageId) {
        return Bundle.getString(storyPrefix + messageId, messageId);
    }

    public static final String getLabel(String messageId) {
        return Bundle.getString(labelPrefix + messageId, null);
    }

    public static final String getMessage(String messageId) {
        return Bundle.getString(messagePrefix + messageId, null);
    }

    public static final String getException(String messageId) {
        return Bundle.getString(exceptionPrefix + messageId, null);
    }

    public static final String getAction(String messageId) {
        return Bundle.getString(actionPrefix + messageId, null);
    }

    public static final String getTitle(String messageId) {
        return Bundle.getString(messageId + titlePostfix, null);
    }

    public static final String getUser(String messageId) {
        return Bundle.getString(userPrefix + messageId, messageId);
    }

    public static final void setUser(String applicationName, String messageId, String value) {
        Bundle.setString(applicationName, userPrefix + messageId, value);
    }

    public static final String getEnum(String enumId, String valueId) {
        return Bundle.getString(enumPrefix + enumId + valueId, null);
    }

    public static final String getEnum(Enum<?> enumValue) {
        return Bundle.getEnum(enumValue.getClass().getSimpleName(), enumValue.toString());
    }

    public static final JComboBox<String> getEnum(Class<?> enumClass, Enum<?> defaultValue) {
        String enumName = enumClass.getSimpleName();
        if (!enumClass.isEnum()) {
            throw new IllegalArgumentException(enumName + " is not Enum!");
        }
        JComboBox<String> jComboBox = new JComboBox<String>();
        try {
            Object[] values;
            for (Object value : values = (Object[])enumClass.getMethod("values", new Class[0]).invoke(null, new Object[0])) {
                jComboBox.addItem(Bundle.getEnum(enumName, value.toString()));
            }
            jComboBox.setEditable(false);
            if (defaultValue != null) {
                jComboBox.setSelectedIndex(defaultValue.ordinal());
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(enumName + " is not Enum!");
        }
        return jComboBox;
    }

    public static void setBorder(JComponent jComponent) {
        jComponent.setBorder(BorderFactory.createTitledBorder(Bundle.getTitle(Util.getClassName(jComponent.getClass()))));
    }

    public static void updateBorder(JComponent jComponent) {
        ((TitledBorder)jComponent.getBorder()).setTitle(Bundle.getTitle(Util.getClassName(jComponent.getClass())));
    }

    static void broadcastBundleReloaded() {
        if (Config.isLoaded()) {
            Config.setString("Country", locale.getCountry());
            Config.setString("Language", locale.getLanguage());
            Config.setString("Variant", locale.getVariant());
        }
        for (AbstractButton abstractButton : allActioners) {
            if (abstractButton.getText().isEmpty()) continue;
            abstractButton.setText(Bundle.getAction(abstractButton.getActionCommand()));
        }
        for (AbstractButton abstractButton : allMenus) {
            if (abstractButton.getText().isEmpty()) continue;
            abstractButton.setText(Bundle.getTitle(abstractButton.getActionCommand()));
        }
        for (Dialog dialog : allDialogs.keySet()) {
            dialog.setTitle(Bundle.getTitle(allDialogs.get(dialog)));
        }
        for (AbstractButton abstractButton : allIconToolTips) {
            abstractButton.setToolTipText(Bundle.getAction(abstractButton.getActionCommand()));
        }
        for (JLabel jLabel : allLabels.keySet()) {
            jLabel.setText(Bundle.getLabel(allLabels.get(jLabel)));
        }
        for (JComboBox jComboBox : allEnums.keySet()) {
            try {
                Object[] values;
                Class<?> enumClass = allEnums.get(jComboBox);
                String enumName = enumClass.getSimpleName();
                int idx = jComboBox.getSelectedIndex();
                jComboBox.removeAllItems();
                for (Object value : values = (Object[])enumClass.getMethod("values", new Class[0]).invoke(null, new Object[0])) {
                    jComboBox.addItem(Bundle.getEnum(enumName, value.toString()));
                }
                jComboBox.setEditable(false);
                jComboBox.setSelectedIndex(idx);
            }
            catch (Exception exception) {}
        }
        bundleObservable.broadcastUpdate("Bundle");
    }

    public static void addLocalizedActioner(AbstractButton button) {
        allActioners.add(button);
    }

    public static void addLocalizedMenu(AbstractButton button) {
        allMenus.add(button);
    }

    public static void addLocalizedDialog(Dialog dialog, String titleId) {
        allDialogs.put(dialog, titleId);
    }

    public static void addLocalizedToolTip(AbstractButton button) {
        allIconToolTips.add(button);
    }

    public static void addLocalizedLabel(JLabel jLabel, String messageId) {
        allLabels.put(jLabel, messageId);
    }

    public static void addLocalizedEnum(JComboBox<String> jComboBox, Class<?> enumClass) {
        allEnums.put(jComboBox, enumClass);
    }

    public static void addBundleObserver(Object object) {
        bundleObservable.addUpdateObserver(object, "Bundle");
    }

    static {
        bundleControl = new ResourceBundle.Control(){

            private String toResourceName0(String bundleName, String suffix) {
                if (bundleName.contains("://")) {
                    return null;
                }
                return this.toResourceName(bundleName, suffix);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
                String bundleName = this.toBundleName(baseName, locale);
                PropertyResourceBundle bundle = null;
                String resourceName = this.toResourceName0(bundleName, "properties");
                if (resourceName == null) {
                    return bundle;
                }
                URLConnection connection = Config.getDataUrl("data", "config", resourceName).openConnection();
                connection.setUseCaches(false);
                try (InputStream stream = connection.getInputStream();){
                    bundle = new PropertyResourceBundle(stream);
                }
                return bundle;
            }
        };
        configurationModified = false;
        askBundleUseException = true;
        allActioners = new Vector();
        allMenus = new Vector();
        allDialogs = new Hashtable();
        allIconToolTips = new Vector();
        allLabels = new Hashtable();
        allEnums = new Hashtable();
        bundleObservable = new StateNotifier();
    }

    static class ApplicationInfo {
        public ResourceBundle messages;
        public Hashtable<String, String> patch = new Hashtable();
        public boolean modified;

        public ApplicationInfo(ResourceBundle messages) {
            this.messages = messages;
        }
    }
}

