/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import misc.ApplicationManager;
import misc.Bundle;
import misc.Config;
import misc.HelpManager;
import misc.OwnFrame;
import misc.Plugins;
import misc.Util;

public abstract class Controller<T>
implements ApplicationManager,
OwnFrame,
ActionListener {
    public static final List<String> actionsNames;
    public static final Hashtable<String, Method> actionsMethod;
    protected JFrame jFrame;
    protected Component component;
    protected JMenuBar menuBar;

    @Override
    public void actionPerformed(ActionEvent e) {
        Util.actionPerformed(actionsMethod, e, this);
    }

    @Override
    public JFrame getJFrame() {
        return this.jFrame;
    }

    public Controller(T t) {
        this.createModel(t);
        this.createAndShowFrame(this.createGUI(), this.createMenuBar());
        Plugins.hideSate();
    }

    protected abstract void createModel(T var1);

    @Override
    public abstract String getTitle();

    @Override
    public abstract Image getIcon();

    public void updateBundle() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Controller.this.jFrame.setTitle(Controller.this.getTitle());
            }
        });
    }

    @Override
    public void reborn() {
        this.jFrame.dispose();
        this.jFrame.setJMenuBar(null);
        this.jFrame.getContentPane().remove(this.component);
        this.createAndShowFrame(this.component, this.menuBar);
    }

    protected void createAndShowFrame(Component component, JMenuBar menuBar) {
        JFrame newJFrame = new JFrame(this.getTitle());
        newJFrame.setIconImage(this.getIcon());
        newJFrame.setJMenuBar(menuBar);
        newJFrame.getContentPane().add(component, "Center");
        newJFrame.pack();
        newJFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Config.saveLocation("Frame", Controller.this.jFrame);
                if (Controller.this.tryClosingWindows()) {
                    Controller.this.quit();
                } else {
                    Controller.this.reborn();
                }
            }
        });
        if (this.jFrame == null) {
            newJFrame.setLocationRelativeTo(null);
            Config.loadLocation("Frame", newJFrame, newJFrame.getLocation());
        } else {
            newJFrame.setLocation(this.jFrame.getLocation());
        }
        this.jFrame = newJFrame;
        this.component = component;
        this.menuBar = menuBar;
        this.jFrame.setVisible(true);
        this.newJFrame();
    }

    protected void newJFrame() {
    }

    protected Component createGUI() {
        Bundle.addBundleObserver(this);
        return new JLabel("Empty controller");
    }

    protected JMenuBar createMenuBar() {
        return null;
    }

    public void quit() {
        System.exit(0);
    }

    public void actionQuit() {
        Config.saveLocation("Frame", this.jFrame);
        if (this.tryClosingWindows()) {
            this.quit();
        }
    }

    protected boolean tryClosingWindows() {
        switch (JOptionPane.showConfirmDialog(this.jFrame, "Do you want to quit ?", "Quit", 0, 2)) {
            case 0: {
                return true;
            }
            case -1: 
            case 1: {
                return false;
            }
        }
        return true;
    }

    @Override
    public void addMenuItem(JMenu ... jMenu) {
        Util.addMenuItem(actionsNames, (ActionListener)this, (Container)jMenu[0]);
    }

    @Override
    public void addIconButtons(Container ... containers) {
        Util.addIconButton(actionsNames, (ActionListener)this, containers[0]);
    }

    @Override
    public void addActiveButtons(Hashtable<String, AbstractButton> buttons) {
    }

    public static void main(String[] args) {
        Config.load("Misc");
        Bundle.load("Help");
        Bundle.load("Controller");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                class ControllerTest
                extends Controller<String> {
                    public ControllerTest() {
                        super("");
                    }

                    @Override
                    protected void createModel(String s) {
                    }

                    @Override
                    public String getTitle() {
                        return null;
                    }

                    @Override
                    public Image getIcon() {
                        return Util.loadImageIcon(Config.getString("MiscIcon", "data/images/misc.png")).getImage();
                    }

                    @Override
                    protected JMenuBar createMenuBar() {
                        class JControllerTestMenu
                        extends JMenuBar {
                            public JControllerTestMenu(ApplicationManager controllerManager, ApplicationManager helpManager) {
                                this.setLayout(new BoxLayout(this, 0));
                                JMenu fileMenu = Util.addJMenu(this, "File");
                                this.add(Box.createHorizontalGlue());
                                JMenu helpMenu = Util.addJMenu(this, "Help");
                                controllerManager.addMenuItem(fileMenu);
                                helpManager.addMenuItem(helpMenu);
                                Hashtable<String, AbstractButton> buttons = new Hashtable<String, AbstractButton>();
                                Util.collectButtons(buttons, fileMenu);
                                Util.collectButtons(buttons, helpMenu);
                                controllerManager.addActiveButtons(buttons);
                                helpManager.addActiveButtons(buttons);
                            }
                        }
                        return new JControllerTestMenu(this, new HelpManager(this, "Misc"));
                    }

                    @Override
                    protected Component createGUI() {
                        return new JLabel("Affichage de la licence.");
                    }

                    @Override
                    protected boolean tryClosingWindows() {
                        Config.save("Misc");
                        return true;
                    }
                }
                new ControllerTest();
            }
        });
    }

    static {
        Properties props = System.getProperties();
        props.setProperty("java.net.preferIPv4Stack", "true");
        System.setProperties(props);
        actionsNames = Arrays.asList("Quit");
        actionsMethod = Util.collectMethod(Controller.class, actionsNames);
    }
}

