/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import misc.ApplicationManager;
import misc.JRemoteUpdate;
import misc.OwnFrame;
import misc.RemoteUpdate;
import misc.Util;

public class RemoteUpdateManager
implements ApplicationManager,
ActionListener {
    public static final String actionUpdate = "Update";
    public static final String actionOnline = "Online";
    public static final List<String> actionsNames = Arrays.asList("Update", "Online");
    public static final Hashtable<String, Method> actionsMethod = Util.collectMethod(RemoteUpdateManager.class, actionsNames);
    private ArrayList<AbstractButton> enabledConnectedButtons = new ArrayList();
    private boolean connected = false;
    private RemoteUpdate remoteUpdate;
    private JRemoteUpdate jRemoteUpdate;

    @Override
    public void actionPerformed(ActionEvent e) {
        Util.actionPerformed(actionsMethod, e, this);
    }

    @Override
    public void addMenuItem(JMenu ... jMenu) {
        Util.addMenuItem(actionsNames, (ActionListener)this, (Container)jMenu[0]);
    }

    @Override
    public void addIconButtons(Container ... containers) {
        Util.addIconButton(actionsNames, (ActionListener)this, containers[0]);
    }

    @Override
    public void addActiveButtons(Hashtable<String, AbstractButton> buttons) {
        this.enabledConnectedButtons.add(buttons.get(actionOnline));
        this.updateActiveButtons();
    }

    public void updateActiveButtons() {
        for (AbstractButton button : this.enabledConnectedButtons) {
            button.setEnabled(this.connected);
        }
    }

    public void actionUpdate() {
        this.jRemoteUpdate.downloadDialog();
    }

    public void actionOnline() {
        this.jRemoteUpdate.uploadDialog();
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
        this.updateActiveButtons();
    }

    public RemoteUpdate getRemoteUpdate() {
        return this.remoteUpdate;
    }

    public JRemoteUpdate getJRemoteUpdate() {
        return this.jRemoteUpdate;
    }

    public RemoteUpdateManager(OwnFrame controller, RemoteUpdate remoteUpdate, Runnable actionAfterUpdate) {
        this.remoteUpdate = remoteUpdate;
        this.jRemoteUpdate = new JRemoteUpdate(controller, remoteUpdate, actionAfterUpdate);
    }

    public void check() {
        new Thread(){

            @Override
            public void run() {
                if (RemoteUpdateManager.this.remoteUpdate.hasNewVersion()) {
                    RemoteUpdateManager.this.jRemoteUpdate.downloadDialog();
                }
            }
        }.start();
    }
}

