/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import misc.ApplicationManager;
import misc.Bundle;
import misc.Story;
import misc.Util;

public class StoryManager
implements ApplicationManager,
ActionListener {
    public static final String actionUndo = "Undo";
    public static final String actionRedo = "Redo";
    public static final List<String> actionsNames = Arrays.asList("Undo", "Redo");
    public static final Hashtable<String, Method> actionsMethod = Util.collectMethod(StoryManager.class, actionsNames);
    private ArrayList<AbstractButton> enabledUndoButtons = new ArrayList();
    private ArrayList<AbstractButton> enabledRedoButtons = new ArrayList();
    Story story;

    @Override
    public void actionPerformed(ActionEvent e) {
        Util.actionPerformed(actionsMethod, e, this);
    }

    @Override
    public void addMenuItem(JMenu ... jMenu) {
        Util.addMenuItem(actionsNames, (ActionListener)this, (Container)jMenu[0]);
    }

    @Override
    public void addIconButtons(Container ... containers) {
        this.addListButton(Util.addIconButton(actionUndo, (ActionListener)this, containers[0]), true);
        this.addListButton(Util.addIconButton(actionRedo, (ActionListener)this, containers[0]), false);
    }

    public void addListButton(final JButton button, final boolean undo) {
        Dimension currentSize = button.getPreferredSize();
        button.setLayout(new BorderLayout());
        final JLabel develop = new JLabel(Util.loadActionIcon("develop"));
        Dimension addedSize = develop.getPreferredSize();
        button.add((Component)develop, "East");
        currentSize.width += addedSize.width;
        button.setPreferredSize(currentSize);
        develop.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                button.setSelected(false);
                if (!button.isEnabled() || StoryManager.this.story == null) {
                    return;
                }
                new JStoryPopup(button, undo, SwingUtilities.convertMouseEvent(develop, e, button).getPoint());
            }
        });
    }

    @Override
    public void addActiveButtons(Hashtable<String, AbstractButton> buttons) {
        this.enabledUndoButtons.add(buttons.get(actionUndo));
        this.enabledRedoButtons.add(buttons.get(actionRedo));
        this.updateActiveButtons();
    }

    public void updateActiveButtons() {
        this.updateStory();
    }

    public void updateStory() {
        boolean undo = false;
        boolean redo = false;
        if (this.story != null) {
            undo = this.story.undoAvailable();
            redo = this.story.redoAvailable();
        }
        for (AbstractButton button : this.enabledUndoButtons) {
            button.setEnabled(undo);
        }
        for (AbstractButton button : this.enabledRedoButtons) {
            button.setEnabled(redo);
        }
    }

    public void actionUndo() {
        if (this.story == null) {
            return;
        }
        this.story.undo(1);
    }

    public void actionRedo() {
        if (this.story == null) {
            return;
        }
        this.story.redo(1);
    }

    public void setStory(Story story) {
        if (this.story != null) {
            this.story.removeObserver(this);
        }
        this.story = story;
        if (story != null) {
            story.addUpdateObserver(this);
        }
        this.updateStory();
    }

    class JStoryPopup
    extends JPopupMenu {
        public JStoryPopup(JButton button, final boolean undo, Point pos) {
            Vector<String> cmds = undo ? StoryManager.this.story.getUndoCmd() : StoryManager.this.story.getRedoCmd();
            for (int i = 0; i < cmds.size(); ++i) {
                if (i >= 10) {
                    this.add(new JLabel("..."));
                    break;
                }
                JMenuItem jMenu = new JMenuItem(Bundle.getStory(cmds.get(i)));
                final int count = i + 1;
                jMenu.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (undo) {
                            StoryManager.this.story.undo(count);
                        } else {
                            StoryManager.this.story.redo(count);
                        }
                    }
                });
                this.add(jMenu);
            }
            this.show(button, pos.x, pos.y);
        }
    }
}

