/*
 * Decompiled with CFR 0.152.
 */
package tp6.model;

import java.awt.Image;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.util.Comparator;
import javax.swing.ImageIcon;
import misc.Config;
import misc.Util;

public class Player
implements Comparable<Player> {
    public static final File dataDir = Config.findDataDir();
    public static final String avatarDirname = "avatars";
    public static final File avatarDir = new File(new File(dataDir, "images"), "avatars");
    public static final int sideIcon = 48;
    public static final int halfSideIcon = 24;
    private String name;
    private String ip;
    private int port;
    private PlayerState state = PlayerState.connected;
    private String avatar;
    private ImageIcon icon;
    private ImageIcon halfIcon;
    public static NameComparator nameComparator = new NameComparator();

    public String getName() {
        return this.name;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public ImageIcon getHalfIcon() {
        return this.halfIcon;
    }

    public PlayerState getState() {
        return this.state;
    }

    public void setState(PlayerState state) {
        this.state = state;
    }

    public Player(String name, String ip, int port, String avatar) {
        this(name, ip, port);
        this.setIcon(avatar);
    }

    public Player(String name, String ip, int port) {
        this.name = name;
        this.ip = ip;
        this.port = port;
    }

    public void setAvatar(String avatar) {
        this.setIcon(avatar);
    }

    public void changeIdent(String name, String avatar) {
        this.name = name;
        this.setAvatar(avatar);
    }

    public void setIcon(String iconName) {
        ImageIcon icon = Player.loadIcon(iconName);
        if (icon == null) {
            this.halfIcon = null;
            this.icon = null;
            this.avatar = null;
            return;
        }
        Image img = icon.getImage();
        this.icon = new ImageIcon(img.getScaledInstance(48, 48, 4));
        this.halfIcon = new ImageIcon(img.getScaledInstance(24, 24, 4));
        this.avatar = iconName;
    }

    public boolean updateIcon(Player newPlayer) {
        if (newPlayer.icon == null || this.icon != null) {
            return false;
        }
        this.avatar = newPlayer.avatar;
        this.icon = newPlayer.icon;
        this.halfIcon = newPlayer.halfIcon;
        return true;
    }

    public static ImageIcon loadIcon(String avatarName) {
        if (avatarName == null || "".equals(avatarName)) {
            return null;
        }
        Image img = null;
        try {
            img = Util.loadImage("data", "images", avatarDirname, avatarName);
            if (img == null) {
                img = new ImageIcon(new URL(avatarName)).getImage();
            }
            return new ImageIcon(img.getScaledInstance(48, 48, 4));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String[] getAvatarsName() {
        return avatarDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !name.startsWith(".") && name.endsWith(".png");
            }
        });
    }

    public String toString() {
        return this.name + "@" + this.ip + ":" + this.port;
    }

    @Override
    public int compareTo(Player player) {
        int diff = this.ip.compareTo(player.ip);
        if (diff != 0) {
            return diff;
        }
        return this.port - player.port;
    }

    public int hashCode() {
        return 7 * this.ip.hashCode() + this.port;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Player)) {
            return false;
        }
        Player player = (Player)obj;
        return this.ip.equals(player.ip) && this.port == player.port;
    }

    public static class NameComparator
    implements Comparator<Player> {
        @Override
        public boolean equals(Object obj) {
            return obj == this;
        }

        @Override
        public int compare(Player o1, Player o2) {
            int diff = o1.name.compareTo(o2.name);
            if (diff != 0) {
                return diff;
            }
            diff = o1.ip.compareTo(o2.ip);
            if (diff != 0) {
                return diff;
            }
            return o1.port - o2.port;
        }

        public int hashCode() {
            return 1001;
        }
    }

    public static enum PlayerState {
        connected,
        guested,
        engaged,
        player,
        owner;

    }
}

