/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import misc.ApplicationManager;
import misc.Bundle;
import misc.HtmlDialog;
import misc.JConsole;
import misc.Log;
import misc.OwnFrame;
import misc.Util;

public class HelpManager
implements ApplicationManager,
ActionListener {
    private Frame frame;
    private OwnFrame controller;
    private String applicationName;
    private JConsole jConsole;
    public static final String actionForcePack = "ForcePack";
    public static final String actionBugReport = "BugReport";
    public static final String actionJConsole = "JConsole";
    public static final List<String> actionsNames = Arrays.asList("About", "Licence", "Locale");
    public static final List<String> actionsBugNames = Arrays.asList("ForcePack", "BugReport", "JConsole");
    public static final Hashtable<String, Method> actionsMethod = Util.collectMethod(HelpManager.class, actionsNames, actionsBugNames);
    private HtmlDialog aboutDialog;
    private HtmlDialog licenceDialog;

    @Override
    public void actionPerformed(ActionEvent e) {
        Util.actionPerformed(actionsMethod, e, this);
    }

    public HelpManager(OwnFrame controller, String applicationName) {
        this.controller = controller;
        this.applicationName = applicationName;
        this.frame = new Frame();
        this.frame.setIconImage(controller.getIcon());
        this.aboutDialog = new HtmlDialog(this.frame, "About", "data/texts/About" + applicationName + ".html");
        this.licenceDialog = new HtmlDialog(this.frame, "Licence", "data/texts/" + applicationName + "Licence" + ".html");
        this.jConsole = new JConsole(this.frame);
    }

    public void actionAbout() {
        this.aboutDialog.restart();
        this.aboutDialog.setVisible(true);
    }

    public void actionLicence() {
        this.licenceDialog.restart();
        this.licenceDialog.setVisible(true);
    }

    public void actionLocale() {
        HelpManager.actionLocale(this.controller);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void actionLocale(OwnFrame controller) {
        try {
            Locale[] locales = Bundle.getApplicationsLocales();
            JComboBox<String> localesList = Bundle.getJComboFlags(locales);
            Locale currentLocale = Bundle.getLocale();
            int currentIndex = 0;
            if (currentLocale != null) {
                for (int i = 0; i < locales.length; ++i) {
                    if (!currentLocale.equals(locales[i])) continue;
                    currentIndex = i;
                    break;
                }
            }
            localesList.setSelectedIndex(currentIndex);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)new JLabel(Bundle.getMessage("ChooseLocale")), "First");
            jPanel.add(localesList, "Center");
            JFrame frame = controller != null ? controller.getJFrame() : null;
            JFrame frmOpt = null;
            if (frame == null) {
                frmOpt = new JFrame();
                frmOpt.setVisible(true);
                frmOpt.setLocationRelativeTo(null);
                frmOpt.setAlwaysOnTop(true);
                frame = frmOpt;
            }
            try {
                if (0 != JOptionPane.showConfirmDialog(frame, jPanel, Bundle.getTitle("ChangeLocale"), 2, 1)) {
                    return;
                }
            }
            finally {
                if (frmOpt != null) {
                    frmOpt.dispose();
                }
            }
            Bundle.setLocale(locales[localesList.getSelectedIndex()]);
            Util.packWindow(frame);
        }
        catch (Exception e) {
            Log.keepLastException("HelpManager::actionLocale", e);
        }
    }

    public void actionForcePack() {
        this.controller.reborn();
    }

    public void actionBugReport() {
        Log.dumpSaveDialog(this.controller.getJFrame());
    }

    public void actionJConsole(boolean checked) {
        this.jConsole.setVisible(checked);
        Util.updateCheckBox(actionJConsole, checked);
    }

    @Override
    public void addMenuItem(JMenu ... jMenu) {
        Util.addMenuItem(actionsNames, (ActionListener)this, (Container)jMenu[0]);
        Util.addMenuItem(actionForcePack, (ActionListener)this, (Container)jMenu[0]);
        Util.addMenuItem(actionBugReport, (ActionListener)this, (Container)jMenu[0]);
        Util.addCheckMenuItem(actionJConsole, (ActionListener)this, (Container)jMenu[0]);
    }

    @Override
    public void addIconButtons(Container ... containers) {
        Util.addIconButton(actionsNames, (ActionListener)this, containers[0]);
        Util.addIconButton(actionForcePack, (ActionListener)this, containers[0]);
        Util.addIconButton(actionBugReport, (ActionListener)this, containers[0]);
    }

    @Override
    public void addActiveButtons(Hashtable<String, AbstractButton> buttons) {
        Log.addDumpCommand(buttons.get(actionBugReport));
    }
}

