/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JTextField;

public class HourPanel
extends JTextField
implements KeyListener,
FocusListener {
    public static final SimpleDateFormat hourFormat = new SimpleDateFormat("HH:mm");
    public static final String acceptChar = "0123456789: ";
    private boolean justFocus = false;
    int lastJTextPos = -1;
    private Dimension tmpSize = new Dimension();
    private Dimension size;

    public HourPanel() {
        super("23:59");
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.set(new Date());
    }

    public void enter() {
        this.tuneHour();
    }

    public void set(Date date) {
        this.setText(hourFormat.format(date));
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.lastJTextPos = this.getCaretPosition();
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
        char c = e.getKeyChar();
        switch (c) {
            case '\n': {
                this.enter();
                return;
            }
            case ';': {
                e.consume();
                return;
            }
            case '\b': {
                this.justFocus = false;
                return;
            }
            case ' ': {
                this.setText("");
                e.consume();
                return;
            }
        }
        if (acceptChar.indexOf(c) < 0) {
            e.consume();
            return;
        }
        if (this.getSelectedText() == null) {
            if (this.justFocus) {
                this.setText("");
            }
            if (c != ':' && this.getText().length() >= 5) {
                e.consume();
                return;
            }
        } else {
            String text = this.getText();
            this.lastJTextPos = this.getSelectionStart();
            this.setText(text.substring(0, this.getSelectionStart()) + text.substring(this.getSelectionEnd()));
        }
        this.justFocus = false;
        this.processHour(e);
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.justFocus = true;
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.justFocus = false;
        this.tuneHour();
    }

    public void processHour(KeyEvent e) {
        char c = e.getKeyChar();
        String text = this.getText();
        int dpPos = text.indexOf(":");
        if (dpPos >= 0) {
            if (c == ':') {
                if (this.lastJTextPos <= dpPos) {
                    this.setText((this.lastJTextPos == 0 ? "0" : text.substring(0, this.lastJTextPos)) + ":" + text.substring(dpPos + 1));
                } else {
                    this.setText(text.substring(0, dpPos) + ":" + text.substring(this.lastJTextPos));
                }
                this.setCaretPosition(text.indexOf(":") + 1);
                e.consume();
                return;
            }
        } else {
            if (c == ':') {
                return;
            }
            if (text.length() < 1) {
                return;
            }
            if (text.charAt(0) > '2') {
                this.setText(text.charAt(0) + ":" + text.substring(1));
                this.setCaretPosition(this.lastJTextPos + 1);
                return;
            }
            if (text.length() > 1) {
                this.setText(text.substring(0, 2) + ":" + text.substring(2));
                this.setCaretPosition(this.lastJTextPos + 1);
                return;
            }
        }
    }

    public void tuneHour() {
        try {
            String text = this.getText().trim();
            if (text.isEmpty()) {
                this.setText("00:00");
                return;
            }
            switch (text.indexOf(":")) {
                case -1: {
                    text = text + ":0";
                    break;
                }
                case 0: {
                    text = "0" + text;
                }
            }
            if (text.indexOf(":") == text.length() - 1) {
                text = text + "0";
            }
            this.setText(hourFormat.format(hourFormat.parse(text)));
            this.getSize(this.tmpSize);
            if (this.tmpSize.width != 0) {
                this.size = this.tmpSize;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.size != null) {
            return this.size;
        }
        return super.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.size != null) {
            return this.size;
        }
        return super.getPreferredSize();
    }
}

