/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import misc.Bundle;
import misc.Util;

public class LocalizedUserLabel {
    protected boolean isCustomized;
    protected String labelName;
    protected String currentLabel;
    protected String newLabel;
    protected JLabel jLabel;

    public String getLabel() {
        return this.labelName;
    }

    public String getNewLabel() {
        return this.isCustomized ? this.newLabel : null;
    }

    public String getCurrentLabel() {
        return this.currentLabel;
    }

    public JLabel getJLabel() {
        return this.jLabel;
    }

    public LocalizedUserLabel(String labelName, boolean isLocalized, boolean admin) {
        this.isCustomized = isLocalized && admin;
        this.labelName = labelName;
        this.currentLabel = isLocalized ? Bundle.getUser(labelName) : labelName;
        this.jLabel = new JLabel(this.currentLabel, 4);
        if (!this.isCustomized) {
            return;
        }
        this.jLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                LocalizedUserLabel.this.mousePressed(e);
            }
        });
    }

    public void mousePressed(MouseEvent e) {
        if (!this.isCustomized || !SwingUtilities.isRightMouseButton(e)) {
            return;
        }
        Locale locale = Bundle.getLocale();
        ImageIcon flag = Util.loadImageIcon("data", "images", "flags", locale.getCountry().toLowerCase() + ".png");
        if (flag != null) {
            flag.setDescription(locale.toString());
        }
        JLabel jLocal = new JLabel(locale.toString(), flag, 2);
        JTextField jValue = new JTextField(this.newLabel == null ? Bundle.getUser(this.labelName) : this.newLabel, 9);
        JPanel content = Util.getGridBagPanel();
        Util.addComponent(new JLabel(), content, Util.GBC);
        Util.addComponent(jLocal, content, Util.GBCNL);
        Util.addComponent(new JLabel(this.labelName + " : ", 4), content, Util.GBC);
        Util.addComponent(jValue, content, Util.GBCNL);
        if (JOptionPane.showConfirmDialog(e.getComponent(), content, Bundle.getTitle("Localized"), 0) != 0) {
            return;
        }
        this.currentLabel = this.newLabel = jValue.getText();
        this.jLabel.setText(this.currentLabel);
    }
}

