/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.SwingConstants;
import misc.Util;

public class MultiToolBarBorderLayout
implements LayoutManager2,
SwingConstants {
    public static final Hashtable<String, Integer> positionStringToInt;
    public static final Hashtable<Integer, String> positionIntToString;
    int hgap;
    int vgap;
    Container menu;
    Hashtable<Component, Integer> positions = new Hashtable();
    Component center;
    private ArrayList<Component> orderedComponents = new ArrayList();

    public MultiToolBarBorderLayout() {
        this(0, 0);
    }

    public MultiToolBarBorderLayout(int hgap, int vgap) {
        this.hgap = hgap;
        this.vgap = vgap;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    public void setMenu(Container menu) {
        this.menu = menu;
    }

    public void setLayoutOrderedComponents(ArrayList<Component> orderedComponents) {
        if (orderedComponents == null) {
            return;
        }
        this.orderedComponents = orderedComponents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (constraints != null && !(constraints instanceof String)) {
                throw new IllegalArgumentException("cannot add to layout: constraint must be a string (or null)");
            }
            this.addLayoutComponent((String)constraints, comp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void addLayoutComponent(String name, Component comp) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            Integer position;
            if (name == null) {
                name = "Center";
            }
            if ((position = positionStringToInt.get(name)) == 0) {
                if (this.center != null) {
                    this.positions.remove(comp);
                }
                this.center = comp;
            }
            this.positions.put(comp, position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLayoutComponent(Component comp) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            this.positions.remove(comp);
            if (this.center == comp) {
                this.center = null;
            }
        }
    }

    public Object getConstraints(Component comp) {
        try {
            return positionIntToString.get(this.positions.get(comp));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        return this.layoutSize(target, true);
    }

    @Override
    public Dimension preferredLayoutSize(Container target) {
        return this.layoutSize(target, false);
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    Hashtable<Integer, ArrayList<Component>> getSortedComponents(Container target) {
        ArrayList<Component> allComponents = new ArrayList<Component>(this.orderedComponents);
        for (Component c : target.getComponents()) {
            if (allComponents.contains(c)) continue;
            allComponents.add(c);
        }
        Hashtable<Integer, ArrayList<Component>> sortedComponents = new Hashtable<Integer, ArrayList<Component>>();
        Iterator<Serializable> iterator = positionIntToString.keySet().iterator();
        while (iterator.hasNext()) {
            int pos = iterator.next();
            sortedComponents.put(pos, new ArrayList());
        }
        for (Component c : allComponents) {
            Integer position = this.positions.get(c);
            if (!c.isVisible() || position == null) continue;
            sortedComponents.get(position).add(c);
        }
        return sortedComponents;
    }

    int maxSize(ArrayList<Component> components, boolean isMinimum, boolean isHorizontal) {
        int max = 0;
        int componentCount = components.size();
        for (int i = 0; i < componentCount; ++i) {
            Component c = components.get(i);
            Dimension d = isMinimum ? c.getMinimumSize() : c.getPreferredSize();
            max = isHorizontal ? Math.max(max, d.width) : Math.max(max, d.height);
        }
        return max;
    }

    TreeSet<Integer> getIntermediate(ArrayList<Component> components, boolean isMinimum, boolean isHorizontal, int minSize) {
        ArrayList<Integer> sizes = new ArrayList<Integer>();
        int componentCount = components.size();
        for (int i = 0; i < componentCount; ++i) {
            Component c = components.get(i);
            Dimension d = isMinimum ? c.getMinimumSize() : c.getPreferredSize();
            sizes.add(isHorizontal ? d.width : d.height);
        }
        TreeSet<Integer> result = new TreeSet<Integer>();
        int maxComp = componentCount - 1;
        for (int i = 0; i < componentCount; ++i) {
            int size = 0;
            for (int j = i; j < maxComp; ++j) {
                if ((size += ((Integer)sizes.get(j)).intValue()) <= minSize) continue;
                result.add(size);
            }
            maxComp = componentCount;
        }
        return result;
    }

    void swapAxes(Dimension d) {
        int tmp = d.width;
        d.width = d.height;
        d.height = tmp;
    }

    Dimension fill(ArrayList<Component> components, boolean isMinimum, boolean isHorizontal, int maxWidth) {
        int componentCount = components.size();
        int x = 0;
        int y = 0;
        int maxX = 0;
        int rowHeight = 0;
        for (int i = 0; i < componentCount; ++i) {
            Dimension d;
            Component c = components.get(i);
            Dimension dimension = d = isMinimum ? c.getMinimumSize() : c.getPreferredSize();
            if (!isHorizontal) {
                this.swapAxes(d);
            }
            if (x == 0 || x + d.width <= maxWidth) {
                if (x > 0) {
                    x += isHorizontal ? this.hgap : this.vgap;
                }
                x += d.width;
                rowHeight = Math.max(rowHeight, d.height);
                continue;
            }
            maxX = Math.max(maxX, x);
            x = d.width;
            y += (isHorizontal ? this.vgap : this.hgap) + rowHeight;
            rowHeight = d.height;
        }
        Dimension result = new Dimension(Math.max(maxX, x), y + rowHeight);
        return result;
    }

    Dimension getExtra(Hashtable<Integer, ArrayList<Component>> sortedComponents, int northPos, int southPos, boolean isMinimum, boolean isHorizontal, int menuWidth, int extraCenter) {
        int minWidth = Util.max(this.maxSize(sortedComponents.get(0), isMinimum, isHorizontal) + extraCenter, menuWidth, this.maxSize(sortedComponents.get(northPos), isMinimum, isHorizontal), this.maxSize(sortedComponents.get(southPos), isMinimum, isHorizontal));
        TreeSet<Integer> sizes = new TreeSet<Integer>();
        sizes.add(minWidth);
        sizes.addAll(this.getIntermediate(sortedComponents.get(northPos), isMinimum, isHorizontal, minWidth));
        sizes.addAll(this.getIntermediate(sortedComponents.get(southPos), isMinimum, isHorizontal, minWidth));
        int minSurface = Integer.MAX_VALUE;
        int extraHeight = 0;
        Iterator iterator = sizes.iterator();
        while (iterator.hasNext()) {
            int size = (Integer)iterator.next();
            Dimension northDim = this.fill(sortedComponents.get(northPos), isMinimum, isHorizontal, size);
            Dimension southDim = this.fill(sortedComponents.get(southPos), isMinimum, isHorizontal, size);
            int height = northDim.height + southDim.height;
            int width = Util.max(size, northDim.width, southDim.width);
            int surface = height * width;
            if (surface >= minSurface) continue;
            minSurface = surface;
            minWidth = width;
            extraHeight = height;
        }
        Dimension result = new Dimension(minWidth, extraHeight);
        if (!isHorizontal) {
            this.swapAxes(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Dimension layoutSize(Container target, boolean isMinimum) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Hashtable<Integer, ArrayList<Component>> sortedComponents = this.getSortedComponents(target);
            Dimension extraSide = this.getExtra(sortedComponents, 7, 3, isMinimum, false, 0, 0);
            int menuWidth = this.menu == null ? 0 : (isMinimum ? this.menu.getMinimumSize() : this.menu.getPreferredSize()).width;
            Dimension extra = this.getExtra(sortedComponents, 1, 5, isMinimum, true, menuWidth, extraSide.width);
            Insets insets = target.getInsets();
            return new Dimension(extra.width + insets.left + insets.right, extraSide.height + extra.height + insets.top + insets.bottom);
        }
    }

    @Override
    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Hashtable<Integer, ArrayList<Component>> sortedComponents = this.getSortedComponents(target);
            Insets insets = target.getInsets();
            int top = insets.top;
            int bottom = target.getHeight() - insets.bottom;
            int left = insets.left;
            int right = target.getWidth() - insets.right;
            int maxWidth = right - left;
            this.moveComponents(sortedComponents.get(5), 0, (bottom -= this.setComponents(target, sortedComponents.get(5), insets.top, insets.left, true, maxWidth)) - insets.top);
            int maxHeight = bottom - (top += this.setComponents(target, sortedComponents.get(1), insets.top, insets.left, true, maxWidth));
            left += this.setComponents(target, sortedComponents.get(7), top, insets.left, false, maxHeight);
            this.moveComponents(sortedComponents.get(3), (right -= this.setComponents(target, sortedComponents.get(3), top, insets.left, false, maxHeight)) - insets.left, 0);
            if (this.center != null && this.center.isVisible()) {
                this.center.setBounds(left, top, right - left, bottom - top);
            }
            target.repaint();
        }
    }

    private void moveComponents(ArrayList<Component> components, int dx, int dy) {
        int componentCount = components.size();
        for (int i = 0; i < componentCount; ++i) {
            Component c = components.get(i);
            c.setLocation(c.getX() + dx, c.getY() + dy);
        }
    }

    private int setComponents(Container target, ArrayList<Component> components, int top, int left, boolean isHorizontal, int maxWidth) {
        int x = 0;
        int y = 0;
        int rowHeight = 0;
        int rowStart = 0;
        int componentCount = components.size();
        for (int i = 0; i < componentCount; ++i) {
            Component c = components.get(i);
            Dimension d = c.getPreferredSize();
            c.setSize(d.width, d.height);
            if (!isHorizontal) {
                this.swapAxes(d);
            }
            if (x == 0 || x + d.width <= maxWidth) {
                if (x > 0) {
                    x += isHorizontal ? this.hgap : this.vgap;
                }
                x += d.width;
                rowHeight = Math.max(rowHeight, d.height);
                continue;
            }
            this.setComponents(target, left, top, components, rowStart, i, isHorizontal, y, rowHeight);
            x = d.width;
            y += (isHorizontal ? this.vgap : this.hgap) + rowHeight;
            rowHeight = d.height;
            rowStart = i;
        }
        this.setComponents(target, left, top, components, rowStart, componentCount, isHorizontal, y, rowHeight);
        return y + rowHeight;
    }

    private void setComponents(Container target, int x, int y, ArrayList<Component> components, int rowStart, int rowEnd, boolean isHorizontal, int delta, int maxSize) {
        for (int i = rowStart; i < rowEnd; ++i) {
            Component c = components.get(i);
            if (isHorizontal) {
                int cy = y + delta + (maxSize - c.getHeight()) / 2;
                c.setLocation(x, cy);
                x += c.getWidth() + this.hgap;
                continue;
            }
            int cx = x + delta + (maxSize - c.getWidth()) / 2;
            c.setLocation(cx, y);
            y += c.getHeight() + this.vgap;
        }
    }

    public String toString() {
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + "]";
    }

    static {
        positionIntToString = new Hashtable();
        positionIntToString.put(0, "Center");
        positionIntToString.put(1, "North");
        positionIntToString.put(3, "East");
        positionIntToString.put(5, "South");
        positionIntToString.put(7, "West");
        positionStringToInt = new Hashtable();
        for (int key : positionIntToString.keySet()) {
            positionStringToInt.put(positionIntToString.get(key), key);
        }
    }
}

