/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import misc.DimensionDouble;

public class ScaledImage {
    public static final RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    public static final int defaultAdjust = 8;
    public BufferedImage original;
    public boolean horizontalSpin;
    public boolean verticalSpin;
    Hashtable<Integer, Hashtable<Dimension, ImageInfo>> scalesRotations = new Hashtable();
    public static final Point2D ORIGINE = new Point2D.Double(0.0, 0.0);
    public static final Dimension ONE_TILE = new Dimension(1, 1);

    public ScaledImage(BufferedImage image) {
        this.original = image;
    }

    public ScaledImage(BufferedImage image, boolean horizontalSpin, boolean verticalSpin) {
        this.original = image;
        this.horizontalSpin = horizontalSpin;
        this.verticalSpin = verticalSpin;
    }

    public ScaledImage getNewSpin(boolean horizontalSpin, boolean verticalSpin) {
        if (this.horizontalSpin == horizontalSpin && this.verticalSpin == verticalSpin) {
            return this;
        }
        return new ScaledImage(this.original, this.horizontalSpin ^ horizontalSpin, this.verticalSpin ^ verticalSpin);
    }

    public AffineTransform getAffineTransform(Dimension2D size, double theta) {
        int width = this.original.getWidth();
        int height = this.original.getHeight();
        double scaleX = size.getWidth() / (double)width;
        double scaleY = size.getHeight() / (double)height;
        if (scaleX == 0.0 || scaleY == 0.0) {
            return null;
        }
        if (this.horizontalSpin) {
            scaleX = -scaleX;
        }
        if (this.verticalSpin) {
            scaleY = -scaleY;
        }
        AffineTransform at = AffineTransform.getRotateInstance(Math.toRadians((int)Math.toDegrees(theta)));
        at.scale(scaleX, scaleY);
        at.translate((double)(-width) / 2.0, (double)(-height) / 2.0);
        return at;
    }

    public ImageIcon get(Dimension size, double theta) {
        return this.get(size, theta, ONE_TILE);
    }

    public ImageIcon get(Dimension size, double theta, Dimension tile) {
        if (tile.width <= 0 || tile.height <= 0) {
            return null;
        }
        ImageInfo imageInfo = this.getInfo(size, theta);
        if (imageInfo == null) {
            return null;
        }
        ImageIcon imageIcon = imageInfo.tiles.get(tile);
        if (imageIcon != null) {
            return imageIcon;
        }
        AffineTransformOp op = new AffineTransformOp(imageInfo.at, renderingHints);
        BufferedImage image = op.createCompatibleDestImage(this.original, null);
        Graphics2D printGraphics = (Graphics2D)image.getGraphics();
        printGraphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.print(printGraphics, null, imageInfo, tile);
        imageIcon = new ImageIcon(image);
        imageInfo.tiles.put(tile, imageIcon);
        return imageIcon;
    }

    public void print(Graphics2D printGraphics, Point2D pos, ImageInfo imageInfo, Dimension tile) {
        if (pos != null) {
            printGraphics.translate(pos.getX() + imageInfo.x, pos.getY() + imageInfo.y);
        }
        if (ONE_TILE.equals(tile)) {
            printGraphics.drawImage(this.original, imageInfo.at, null);
        } else {
            double width = this.original.getWidth();
            double height = this.original.getHeight();
            double scaleX = 1.0 / (double)tile.width;
            double scaleY = 1.0 / (double)tile.height;
            double stepX = width / (double)tile.width;
            double stepY = height / (double)tile.height;
            for (int i = 0; i < tile.width; ++i) {
                for (int j = 0; j < tile.height; ++j) {
                    AffineTransform at = new AffineTransform(imageInfo.at);
                    at.translate((double)i * stepX, (double)j * stepY);
                    at.scale(scaleX, scaleY);
                    printGraphics.drawImage(this.original, at, null);
                }
            }
        }
        if (pos != null) {
            printGraphics.translate(-pos.getX() - imageInfo.x, -pos.getY() - imageInfo.y);
        }
    }

    public void print(Graphics2D printGraphics, Point2D pos, DimensionDouble size, double theta, Dimension tile) {
        this.print(printGraphics, pos, this.newInfo(size, theta), tile);
    }

    public double[] getBounds(Dimension size, double theta) {
        ImageInfo imageInfo = this.getInfo(size, theta);
        if (imageInfo == null) {
            return null;
        }
        return imageInfo.bounds;
    }

    public ImageInfo getInfo(Dimension size, double theta) {
        ImageInfo imageInfo;
        int angle = (int)Math.toDegrees(theta);
        Hashtable<Dimension, ImageInfo> rotated = this.scalesRotations.get(angle);
        if (rotated == null) {
            rotated = new Hashtable();
            this.scalesRotations.put(angle, rotated);
        }
        if ((imageInfo = rotated.get(size)) != null) {
            return imageInfo;
        }
        imageInfo = this.newInfo(new DimensionDouble(size.width, size.height), theta);
        if (imageInfo == null) {
            return null;
        }
        rotated.put(size, imageInfo);
        return imageInfo;
    }

    public ImageInfo newInfo(DimensionDouble size, double theta) {
        int width = this.original.getWidth();
        int height = this.original.getHeight();
        double scaleX = size.getWidth() / (double)width;
        double scaleY = size.getHeight() / (double)height;
        if (scaleX == 0.0 || scaleY == 0.0) {
            return null;
        }
        if (this.horizontalSpin) {
            scaleX = -scaleX;
        }
        if (this.verticalSpin) {
            scaleY = -scaleY;
        }
        AffineTransform at = this.getAffineTransform(size, theta);
        double[] bounds = new double[]{0.0, 0.0, 0.0, height, width, height, width, 0.0};
        at.transform(bounds, 0, bounds, 0, 4);
        double dx = bounds[0];
        double dy = bounds[1];
        for (int i = 1; i < 4; ++i) {
            dx = Math.min(dx, bounds[i * 2]);
            dy = Math.min(dy, bounds[i * 2 + 1]);
        }
        at.preConcatenate(AffineTransform.getTranslateInstance(-dx, -dy));
        return new ImageInfo(at, bounds, dx, dy);
    }

    public ImageIcon getSide(int max) {
        int height;
        int width = this.original.getWidth();
        return this.get(width > (height = this.original.getHeight()) ? new Dimension(max, height * max / width) : new Dimension(width * max / height, max), 0.0);
    }

    public ImageIcon getInsideFit(int maxWidth, int maxHeight, int adjust) {
        return this.getInside(Math.min(this.original.getWidth(), maxWidth / adjust * adjust), Math.min(this.original.getHeight(), maxHeight / adjust * adjust));
    }

    public ImageIcon getInside(int maxWidth, int maxHeight) {
        int height;
        int width = this.original.getWidth();
        return this.get(width * maxHeight / (height = this.original.getHeight()) > maxWidth ? new Dimension(maxWidth, height * maxWidth / width) : new Dimension(width * maxHeight / height, maxHeight), 0.0);
    }

    public ImageIcon get(DimensionDouble real, double scale, double theta) {
        return this.get(new Dimension((int)(real.getWidth() * scale), (int)(real.getHeight() * scale)), 0.0);
    }

    static class ImageInfo {
        public AffineTransform at;
        public double[] bounds;
        public double x;
        public double y;
        Hashtable<Dimension, ImageIcon> tiles = new Hashtable();

        public ImageInfo(AffineTransform at, double[] bounds, double x, double y) {
            this.at = at;
            this.bounds = bounds;
            this.x = x;
            this.y = y;
        }
    }
}

