/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.table.AbstractTableModel;
import misc.ApplicationManager;
import misc.Bundle;
import misc.Config;
import misc.Log;
import misc.MultiToolBarBorderLayout;
import misc.TitledDialog;
import misc.Util;

public class ToolBarManager
implements ApplicationManager,
ActionListener,
ContainerListener,
SwingConstants {
    public static BasicButtonUI buttonUI = new BasicButtonUI();
    public static Border buttonBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);
    public static final String actionUp = "Up";
    public static final String actionDown = "Down";
    public static final String actionToolBarProfil = "ToolBarProfil";
    public static final List<String> actionsToolBar = Arrays.asList("ToolBarProfil");
    public static final Hashtable<String, Method> actionsMethod = Util.collectMethod(ToolBarManager.class, actionsToolBar);
    TableObjectModel dataObjectModel = new TableObjectModel();
    JTable table = new JTable(this.dataObjectModel);
    static final List<Integer> horizontalCardinal = Arrays.asList(1, 5);
    private Container container;
    private Hashtable<Component, String> toolBarName = new Hashtable();
    private Hashtable<Component, Integer> toolBarOrder = new Hashtable();
    private ArrayList<Component> orderedComponents = new ArrayList();
    private Hashtable<String, Component> toolBarComponent = new Hashtable();
    private Hashtable<Component, String> toolBarPlace = new Hashtable();
    private Hashtable<String, Vector<AbstractButton>> nameCheckBox = new Hashtable();
    JFrame frame = new JFrame();
    public Comparator<Component> componentsComparator = new Comparator<Component>(){

        @Override
        public int compare(Component o1, Component o2) {
            Integer i2;
            Integer i1 = (Integer)ToolBarManager.this.toolBarOrder.get(o1);
            if (i1 == (i2 = (Integer)ToolBarManager.this.toolBarOrder.get(o2))) {
                return o1.hashCode() - o2.hashCode();
            }
            if (i1 == null || i2 == null) {
                return i2 == null ? 1 : -1;
            }
            return i1 - i2;
        }
    };

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            AbstractButton button = (AbstractButton)e.getSource();
            Component component = this.toolBarComponent.get(button.getActionCommand());
            if (component != null) {
                if (button.isSelected()) {
                    this.show(component);
                } else {
                    this.hide(component);
                }
                return;
            }
        }
        catch (Exception e2) {
            Log.keepLastException("ToolBarManager::actionPerformed", e2);
        }
        Util.actionPerformed(actionsMethod, e, this);
    }

    @Override
    public void addMenuItem(JMenu ... jMenu) {
        Util.addMenuItem(actionsToolBar, (ActionListener)this, (Container)jMenu[0]);
        ((MultiToolBarBorderLayout)this.container.getLayout()).setMenu(jMenu[0].getParent());
    }

    @Override
    public void addIconButtons(Container ... containers) {
        Util.addIconButton(actionsToolBar, (ActionListener)this, containers[0]);
    }

    @Override
    public void addActiveButtons(Hashtable<String, AbstractButton> buttons) {
    }

    public void actionToolBarProfil() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)Util.getJScrollPane(this.table), "Center");
        JPanel leftPropCmdPanel = new JPanel();
        panel.add((Component)leftPropCmdPanel, "South");
        leftPropCmdPanel.add(Util.newIconButton(actionUp, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolBarManager.this.dataObjectModel.move(-1);
            }
        }));
        leftPropCmdPanel.add(Util.newIconButton(actionDown, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolBarManager.this.dataObjectModel.move(1);
            }
        }));
        Hashtable<String, AbstractButton> buttons = Util.collectButtons(null, leftPropCmdPanel);
        Util.collectButtons(buttons, leftPropCmdPanel);
        for (AbstractButton button : buttons.values()) {
            button.setUI(buttonUI);
            button.setBorder(buttonBorder);
        }
        this.table.setShowHorizontalLines(false);
        this.table.setShowVerticalLines(false);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.setSelectionMode(0);
        Dimension preferredSize = new Dimension(this.table.getPreferredSize());
        preferredSize.height += 40;
        this.table.getParent().getParent().setPreferredSize(preferredSize);
        for (int row = 0; row < this.table.getRowCount(); ++row) {
            this.table.getValueAt(row, 1);
        }
        JOptionPane.showMessageDialog(this.frame, panel);
        int i = 0;
        for (Component component : this.orderedComponents) {
            Config.setInt(this.toolBarName.get(component) + "Order", i++);
        }
    }

    public ToolBarManager(Image icon, Container container) {
        this.container = container;
        ((MultiToolBarBorderLayout)container.getLayout()).setLayoutOrderedComponents(this.orderedComponents);
        this.frame.setIconImage(icon);
        container.addContainerListener(this);
    }

    public JToolBar newJToolBar(String toolBarId, String defaultCardinalPoint) {
        JToolBar toolBar = new JToolBar(toolBarId);
        this.add(toolBar, defaultCardinalPoint);
        return toolBar;
    }

    public void add(Component component, String defaultCardinalPoint) {
        String name = component.getName();
        if (this.toolBarName.contains(component)) {
            throw new IllegalArgumentException(MessageFormat.format(Bundle.getException("AlreadyRegistredTool"), name, defaultCardinalPoint));
        }
        this.toolBarName.put(component, name);
        this.toolBarComponent.put(name, component);
        this.nameCheckBox.put(name, new Vector());
        this.toolBarOrder.put(component, Config.getInt(name + "Order", this.toolBarOrder.size()));
        this.orderedComponents.add(component);
        this.orderedComponents.sort(this.componentsComparator);
        String place = Config.getString(name + "Place", defaultCardinalPoint);
        Integer cardinal = MultiToolBarBorderLayout.positionStringToInt.get(place);
        if (cardinal == null || cardinal == 0) {
            throw new IllegalArgumentException(MessageFormat.format(Bundle.getException("NotCardinalPoint"), place));
        }
        this.put(component, place);
        this.showIfVisible(component);
    }

    public void addCheckBox(AbstractButton checkbox) {
        String name = checkbox.getActionCommand();
        Vector<AbstractButton> buttons = this.nameCheckBox.get(name);
        if (buttons == null) {
            return;
        }
        buttons.add(checkbox);
        checkbox.addActionListener(this);
    }

    public void checkBoxComponent(Component component) {
        boolean showed = component.getParent() != null;
        for (AbstractButton checkbox : this.nameCheckBox.get(this.toolBarName.get(component))) {
            try {
                checkbox.getClass().getMethod("setState", Boolean.TYPE).invoke((Object)checkbox, showed);
            }
            catch (NoSuchMethodException e) {
                Log.keepLastException("ToolBarManager::checkBoxComponent", e);
            }
            catch (InvocationTargetException e) {
                Log.keepLastException("ToolBarManager::checkBoxComponent", e);
            }
            catch (IllegalAccessException e) {
                Log.keepLastException("ToolBarManager::checkBoxComponent", e);
            }
        }
    }

    private void newUndocked(final Component component) {
        String name = this.toolBarName.get(component);
        final TitledDialog jdialog = new TitledDialog((Frame)this.frame, name);
        jdialog.add(component);
        ((JToolBar)component).setFloatable(false);
        String place = this.get(component);
        try {
            int cardinal = MultiToolBarBorderLayout.positionStringToInt.get(place);
            ((JToolBar)component).setOrientation(horizontalCardinal.contains(cardinal) ? 0 : 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((JToolBar)component).addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                Util.packWindow(component);
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                Util.packWindow(component);
            }
        });
        jdialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                jdialog.remove(component);
                ((JToolBar)component).setFloatable(true);
                ToolBarManager.this.show(component);
            }
        });
        jdialog.setLocationRelativeTo(null);
        Config.loadLocation(name, jdialog, jdialog.getLocation());
        jdialog.setVisible(true);
        jdialog.pack();
    }

    public void saveLocation() {
        for (Component component : this.toolBarName.keySet()) {
            if (component.getParent() == null || this.container.isAncestorOf(component)) continue;
            Config.saveLocation(this.toolBarName.get(component), this.getUndocked(component));
        }
    }

    public void showIfVisible(Component component) {
        if (Config.getBoolean(this.toolBarName.get(component) + "Checked", true)) {
            if (Config.getBoolean(this.toolBarName.get(component) + "Undocked", false)) {
                this.newUndocked(component);
            } else {
                this.show(component);
            }
        }
    }

    public void show(Component component) {
        String place = this.get(component);
        try {
            int cardinal = MultiToolBarBorderLayout.positionStringToInt.get(place);
            ((JToolBar)component).setOrientation(horizontalCardinal.contains(cardinal) ? 0 : 1);
        }
        catch (Exception cardinal) {
            // empty catch block
        }
        Container parent = component.getParent();
        if (parent != null) {
            return;
        }
        ((JToolBar)component).setFloatable(true);
        this.container.invalidate();
        this.container.add(component, place);
        this.container.validate();
        Config.setBoolean(this.toolBarName.get(component) + "Checked", true);
        this.checkBoxComponent(component);
    }

    private Container getUndocked(Component component) {
        Container frame = component.getParent();
        while (!(frame instanceof Window)) {
            frame = frame.getParent();
        }
        return frame;
    }

    public void hide(Component component) {
        Container parent = component.getParent();
        if (parent == null) {
            return;
        }
        if (this.container.isAncestorOf(component)) {
            this.container.invalidate();
            this.container.remove(component);
            this.container.validate();
        } else {
            try {
                this.getUndocked(component).setVisible(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            parent.remove(component);
        }
        Config.setBoolean(this.toolBarName.get(component) + "Checked", false);
        this.checkBoxComponent(component);
    }

    public void showHide(Component component) {
        if (component.getParent() == null) {
            this.show(component);
        } else {
            this.hide(component);
        }
    }

    private String find(Component component) {
        return (String)((MultiToolBarBorderLayout)this.container.getLayout()).getConstraints(component);
    }

    private String get(Component component) {
        String place = this.toolBarPlace.get(component);
        if (place != null) {
            return place;
        }
        place = "North";
        this.put(component, place);
        return place;
    }

    private void put(Component component, String place) {
        this.toolBarPlace.put(component, place);
        Config.setString(this.toolBarName.get(component) + "Place", place);
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        Component component = e.getChild();
        if (!this.toolBarName.keySet().contains(component)) {
            return;
        }
        String place = this.find(component);
        this.put(component, place);
        Util.packWindow(this.container);
        Config.setBoolean(this.toolBarName.get(component) + "Undocked", false);
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        Util.packWindow(this.container);
        Component component = e.getChild();
        if (!this.toolBarName.keySet().contains(component)) {
            return;
        }
        Config.setBoolean(this.toolBarName.get(component) + "Undocked", true);
    }

    public class TableObjectModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return ToolBarManager.this.orderedComponents.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (row >= ToolBarManager.this.orderedComponents.size()) {
                return null;
            }
            return column == 0 ? Boolean.valueOf(((Component)ToolBarManager.this.orderedComponents.get(row)).getParent() != null) : Bundle.getTitle((String)ToolBarManager.this.toolBarName.get(ToolBarManager.this.orderedComponents.get(row)));
        }

        @Override
        public String getColumnName(int column) {
            return column == 0 ? Bundle.getLabel("ToolBarShowed") : Bundle.getLabel("ToolBarNamed");
        }

        @Override
        public Class<?> getColumnClass(int column) {
            return column == 0 ? Boolean.class : String.class;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            if (column > 0 || row >= ToolBarManager.this.orderedComponents.size()) {
                return;
            }
            Component component = (Component)ToolBarManager.this.orderedComponents.get(row);
            if (((Boolean)aValue).booleanValue()) {
                ToolBarManager.this.show(component);
            } else {
                ToolBarManager.this.hide(component);
            }
        }

        public void move(int delta) {
            int idx = ToolBarManager.this.table.getSelectedRow();
            if (idx < 0) {
                return;
            }
            int mod = ToolBarManager.this.orderedComponents.size();
            Component old = (Component)ToolBarManager.this.orderedComponents.remove(idx);
            if ((idx = (idx + delta + mod) % mod) == ToolBarManager.this.orderedComponents.size()) {
                ToolBarManager.this.orderedComponents.add(old);
            } else {
                ToolBarManager.this.orderedComponents.add(idx, old);
            }
            ToolBarManager.this.table.revalidate();
            ToolBarManager.this.table.getSelectionModel().setLeadSelectionIndex(idx);
            ToolBarManager.this.container.getLayout().layoutContainer(ToolBarManager.this.container);
        }
    }
}

