/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import misc.Bundle;
import misc.Config;
import misc.Log;
import misc.ProgressState;

public class Util
implements SwingConstants {
    public static final Long version = 20170527L;
    public static final int bufSize = 0x100000;
    public static final String NL = System.getProperty("line.separator");
    public static final String ON = "On";
    public static final String OFF = "Off";
    public static BasicButtonUI buttonNoUI = new BasicButtonUI();
    public static Border buttonNoBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);
    public static final GridBagConstraints GBC = new GridBagConstraints();
    public static final GridBagConstraints GBCNL;
    public static final GridBagConstraints GBCLNL;
    public static final GridBagConstraints GBCBNL;
    public static Hashtable<String, ArrayList<AbstractButton>> allCheckBox;
    public static final Dimension space;
    public static boolean packBug;

    public static final String toNumIn2Units(long bytes) {
        if (bytes == 0L) {
            return "0 ";
        }
        int u = 0;
        while (bytes > 0x100000L) {
            ++u;
            bytes >>= 10;
        }
        if (bytes < 1024L) {
            return String.format("%d %c", bytes, Character.valueOf(" kMGTPEZY".charAt(u))).replace("  ", "");
        }
        return String.format("%.1f %c", Float.valueOf((float)bytes / 1024.0f), Character.valueOf(" kMGTPEZY".charAt(++u))).replace(",0 ", " ").replace("  ", "");
    }

    public static final String toNumIn10Units(long bytes) {
        if (bytes == 0L) {
            return "0 ";
        }
        int u = 0;
        while (bytes > 1000000L) {
            ++u;
            bytes >>= 10;
        }
        if (bytes < 1000L) {
            return String.format("%d %c", bytes, Character.valueOf(" kMGTPEZY".charAt(u))).replace("  ", "");
        }
        return String.format("%.1f %c", Float.valueOf((float)bytes / 1000.0f), Character.valueOf(" kMGTPEZY".charAt(++u))).replace(",0 ", " ").replace("  ", "");
    }

    public static final <T> T toEnum(String value, T defaultValue) {
        try {
            return (T)Enum.valueOf(defaultValue.getClass(), value);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static final String toColumn(String[] lines, int nbColumn) {
        int size = lines.length;
        if (size < 1) {
            return "";
        }
        if (size < 2) {
            return lines[0] + "\n";
        }
        String result = "";
        int nbLignes = size / nbColumn;
        int nbLongColumn = size % nbColumn;
        int i = 0;
        int k = 0;
        while (k < size) {
            int idx = i;
            String sep = "";
            for (int j = 0; j < nbColumn && k < size; ++j, ++k) {
                result = result + sep + lines[idx];
                sep = "\t";
                idx += nbLignes;
                if (j >= nbLongColumn) continue;
                ++idx;
            }
            result = result + "\n";
            ++i;
        }
        return result;
    }

    public static final String[] set2string(Set<String> set) {
        String[] result = new String[set.size()];
        int idx = 0;
        for (String key : set) {
            result[idx++] = key;
        }
        return result;
    }

    public static JScrollPane getJScrollPane(Component view) {
        return new JScrollPane(view, 20, 30);
    }

    public static JSplitPane getJSplitPane(int newOrientation, Component newLeftComponent, Component newRightComponent) {
        JSplitPane result = new JSplitPane(newOrientation, newLeftComponent, newRightComponent);
        result.setResizeWeight(0.0);
        result.setOneTouchExpandable(true);
        result.setContinuousLayout(true);
        return result;
    }

    public static final void setEnabled(Component component, boolean enabled) {
        component.setEnabled(enabled);
        try {
            for (Component component2 : ((Container)component).getComponents()) {
                Util.setEnabled(component2, enabled);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static JPanel getGridBagPanel() {
        return new JPanel(new GridBagLayout());
    }

    public static void addLabelFields(Container container, String label, Component ... components) {
        Util.addLabel(label, 4, container, GBC);
        for (int i = 0; i < components.length; ++i) {
            Util.addComponent(components[i], container, i == components.length - 1 ? GBCNL : GBC);
        }
    }

    public static AbstractButton activeButton(AbstractButton button, String action, ActionListener actionListener) {
        button.setActionCommand(action);
        Bundle.addLocalizedActioner(button);
        button.setToolTipText(Bundle.getAction(action));
        Bundle.addLocalizedToolTip(button);
        if (actionListener != null) {
            button.addActionListener(actionListener);
        }
        return button;
    }

    public static final JCheckBox newCheckIcon(String action, ActionListener actionListener) {
        JCheckBox button = new JCheckBox(Util.loadActionIcon(action + OFF));
        button.setSelectedIcon(Util.loadActionIcon(action + ON));
        Util.activeButton(button, action, actionListener);
        return button;
    }

    public static final JCheckBox newCheckIcon(String action, ActionListener actionListener, boolean defaultValue) {
        JCheckBox button = Util.newCheckIcon(action, actionListener);
        button.setSelected(defaultValue);
        return button;
    }

    public static final JCheckBox addCheckIcon(String action, ActionListener actionListener, Container container) {
        JCheckBox button = Util.newCheckIcon(action, actionListener);
        container.add(button);
        return button;
    }

    public static final JCheckBox addCheckIcon(String action, ActionListener actionListener, boolean defaultValue, Container container) {
        JCheckBox button = Util.newCheckIcon(action, actionListener);
        container.add(button);
        button.setSelected(defaultValue);
        return button;
    }

    public static final void addCheckIcon(List<String> actions, ActionListener actionListener, Container container) {
        for (String action : actions) {
            Util.addCheckIcon(action, actionListener, container);
        }
    }

    public static final JCheckBox addCheckIcon(String action, ActionListener actionListener, boolean defaultValue, Container container, GridBagConstraints constraint) {
        JCheckBox button = Util.newCheckIcon(action, actionListener, defaultValue);
        Util.addComponent(button, container, constraint);
        return button;
    }

    public static void setCheckIconTableCellEditorRenderer(String action, TableColumn tableColumn) {
        tableColumn.setCellRenderer(new CheckIconTableCellEditorRenderer(action));
        tableColumn.setCellEditor(new DefaultCellEditor(Util.newCheckIcon(action, null)));
    }

    public static final JCheckBox newCheckButton(String action, ActionListener actionListener) {
        JCheckBox button = new JCheckBox(Bundle.getAction(action), Util.loadActionIcon(action + OFF));
        button.setSelectedIcon(Util.loadActionIcon(action + ON));
        Util.activeButton(button, action, actionListener);
        return button;
    }

    public static final JCheckBox addCheckButton(String action, ActionListener actionListener, Container container) {
        JCheckBox button = Util.newCheckButton(action, actionListener);
        container.add(button);
        return button;
    }

    public static final void addCheckButton(List<String> actions, ActionListener actionListener, Container container) {
        for (String action : actions) {
            Util.addCheckButton(action, actionListener, container);
        }
    }

    public static final JCheckBox addCheckButton(String action, ActionListener actionListener, Container container, GridBagConstraints constraint) {
        JCheckBox button = Util.newCheckButton(action, actionListener);
        Util.addComponent(button, container, constraint);
        return button;
    }

    public static final JCheckBox newCheckButtonConfig(String action, ActionListener actionListener, boolean defaultValue) {
        boolean startValue = Config.getBoolean(action + "Checked", defaultValue);
        JCheckBox button = Util.newCheckButton(action, actionListener);
        button.setSelected(startValue);
        return button;
    }

    public static final JCheckBox addCheckButtonConfig(String action, ActionListener actionListener, boolean defaultValue, Container container) {
        JCheckBox button = Util.newCheckButtonConfig(action, actionListener, defaultValue);
        container.add(button);
        return button;
    }

    public static final JCheckBox addCheckButtonConfig(String action, ActionListener actionListener, boolean defaultValue, Container container, GridBagConstraints constraint) {
        JCheckBox button = Util.newCheckButtonConfig(action, actionListener, defaultValue);
        Util.addComponent(button, container, constraint);
        return button;
    }

    public static final JRadioButton newRadioButton(String action, ActionListener actionListener, ButtonGroup group, String selected) {
        JRadioButton button = new JRadioButton(Bundle.getAction(action), Util.loadActionIcon(action + OFF), action.equals(selected));
        button.setSelectedIcon(Util.loadActionIcon(action + ON));
        Util.activeButton(button, action, actionListener);
        group.add(button);
        return button;
    }

    public static final void addRadioButton(List<String> actions, ActionListener actionListener, ButtonGroup group, String selected, Container container) {
        for (String action : actions) {
            JRadioButton button = Util.newRadioButton(action, actionListener, group, selected);
            container.add(button);
        }
    }

    public static final JRadioButton addRadioButton(String action, ActionListener actionListener, ButtonGroup group, String selected, Container container, GridBagConstraints constraint) {
        JRadioButton button = Util.newRadioButton(action, actionListener, group, selected);
        Util.addComponent(button, container, constraint);
        return button;
    }

    public static final JButton newButton(String action, ActionListener actionListener) {
        JButton button = new JButton(Bundle.getAction(action), Util.loadActionIcon(action));
        Util.activeButton(button, action, actionListener);
        return button;
    }

    public static final void newButton(List<String> actions, ActionListener actionListener) {
        for (String action : actions) {
            Util.newButton(action, actionListener);
        }
    }

    public static final JButton addButton(String action, ActionListener actionListener, Container container) {
        JButton button = Util.newButton(action, actionListener);
        container.add(button);
        return button;
    }

    public static final void addButton(List<String> actions, ActionListener actionListener, Container container) {
        for (String action : actions) {
            Util.addButton(action, actionListener, container);
        }
    }

    public static final JButton addButton(String action, ActionListener actionListener, Container container, GridBagConstraints constraint) {
        JButton button = Util.newButton(action, actionListener);
        Util.addComponent(button, container, constraint);
        return button;
    }

    public static final JButton newIconButton(String action, ActionListener actionListener) {
        JButton button = new JButton(Util.loadActionIcon(action));
        button.setAlignmentX(0.5f);
        Util.activeButton(button, action, actionListener);
        return button;
    }

    public static final void newIconButton(List<String> actions, ActionListener actionListener) {
        for (String action : actions) {
            Util.newIconButton(action, actionListener);
        }
    }

    public static final JButton addIconButton(String action, ActionListener actionListener, Container container) {
        JButton button = Util.newIconButton(action, actionListener);
        container.add(button);
        return button;
    }

    public static final void addIconButton(List<String> actions, ActionListener actionListener, Container container) {
        for (String action : actions) {
            Util.addIconButton(action, actionListener, container);
        }
    }

    public static final JButton addIconButton(String action, ActionListener actionListener, Container container, GridBagConstraints constraint) {
        JButton button = new JButton(Util.loadActionIcon(action));
        Util.activeButton(button, action, actionListener);
        Util.addComponent(button, container, constraint);
        return button;
    }

    public static final void unBoxButton(Container container) {
        for (AbstractButton button : Util.collectButtons(null, container).values()) {
            Util.unBoxButton(button);
        }
    }

    public static final void unBoxButton(AbstractButton button) {
        button.setUI(buttonNoUI);
        button.setBorder(buttonNoBorder);
    }

    public static final void addMenuItem(String action, ActionListener actionListener, Container container) {
        JMenuItem item = new JMenuItem(Bundle.getAction(action), Util.loadActionIcon(action));
        Util.activeButton(item, action, actionListener);
        container.add(item);
    }

    public static final void addMenuItem(List<String> actions, ActionListener actionListener, Container container) {
        for (String action : actions) {
            Util.addMenuItem(action, actionListener, container);
        }
    }

    public static void updateCheckBox(String action, boolean value) {
        ArrayList<AbstractButton> buttons = allCheckBox.get(action);
        if (buttons == null) {
            return;
        }
        Config.setBoolean(action + "Checked", value);
        for (AbstractButton button : buttons) {
            if (button.isSelected() == value) continue;
            button.setSelected(value);
        }
    }

    public static final void addCheckMenuItem(List<String> actions, ActionListener actionListener, Container container) {
        for (String action : actions) {
            Util.addCheckMenuItem(action, actionListener, container);
        }
    }

    public static final JCheckBoxMenuItem addCheckMenuItem(String action, ActionListener actionListener, Container container) {
        return Util.addCheckMenuItem(action, actionListener, Config.getBoolean(action + "Checked", false), container);
    }

    public static final JCheckBoxMenuItem addCheckMenuItem(String action, ActionListener actionListener, boolean defaultValue, Container container) {
        boolean startValue = Config.getBoolean(action + "Checked", defaultValue);
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(Bundle.getAction(action), Util.loadActionIcon(action + OFF), startValue);
        item.setSelectedIcon(Util.loadActionIcon(action + ON));
        Util.activeButton(item, action, actionListener);
        container.add(item);
        ArrayList<AbstractButton> checkList = allCheckBox.get(action);
        if (checkList == null) {
            checkList = new ArrayList();
            allCheckBox.put(action, checkList);
        }
        checkList.add(item);
        return item;
    }

    public static final JMenu addJMenu(JMenuBar jMenuBar, String menuId) {
        JMenu menu = new JMenu(Bundle.getTitle(menuId));
        menu.setActionCommand(menuId);
        Bundle.addLocalizedMenu(menu);
        jMenuBar.add(menu);
        return menu;
    }

    public static void addComponent(Component component, Container container, GridBagConstraints constraint) {
        GridBagLayout gridbag = (GridBagLayout)container.getLayout();
        gridbag.setConstraints(component, constraint);
        container.add(component);
    }

    public static void addTextFieldSlider(JTextField textField, JLabel label, JSlider slider, Container container, GridBagConstraints constraint) {
        JPanel panel = Util.getGridBagPanel();
        Util.addComponent(textField, panel, GBC);
        Util.addComponent(label, panel, GBC);
        Util.addComponent(slider, panel, GBCBNL);
        Util.addComponent(panel, container, constraint);
    }

    public static JLabel newLabel(String messageId, int position) {
        JLabel jLabel = new JLabel(Bundle.getLabel(messageId), position);
        Bundle.addLocalizedLabel(jLabel, messageId);
        return jLabel;
    }

    public static JLabel addLabel(String messageId, int position, Container container) {
        JLabel jLabel = Util.newLabel(messageId, position);
        container.add(jLabel);
        return jLabel;
    }

    public static JLabel addLabel(String messageId, int position, Container container, GridBagConstraints constraint) {
        JLabel jLabel = Util.newLabel(messageId, position);
        Util.addComponent(jLabel, container, constraint);
        return jLabel;
    }

    public static JComboBox<String> newEnum(Class<? extends Enum<?>> enumClass, Enum<?> defaultValue) {
        JComboBox<String> jComboBox = Bundle.getEnum(enumClass, defaultValue);
        Bundle.addLocalizedEnum(jComboBox, enumClass);
        return jComboBox;
    }

    public static JComboBox<String> addEnum(Class<? extends Enum<?>> enumClass, Enum<?> defaultValue, Container container) {
        JComboBox<String> jComboBox = Util.newEnum(enumClass, defaultValue);
        container.add(jComboBox);
        return jComboBox;
    }

    public static JComboBox<String> addEnum(Class<? extends Enum<?>> enumClass, Enum<?> defaultValue, Container container, GridBagConstraints constraint) {
        JComboBox<String> jComboBox = Util.newEnum(enumClass, defaultValue);
        Util.addComponent(jComboBox, container, constraint);
        return jComboBox;
    }

    public static final void setColumnLabels(JTable jTable, String[] columnLabels) {
        for (int i = 0; i < columnLabels.length; ++i) {
            jTable.getColumnModel().getColumn(i).setHeaderValue(Bundle.getLabel(columnLabels[i]));
        }
        try {
            Container parent = jTable.getParent();
            parent.repaint();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int viewToModel(JTable table, int vColIndex) {
        if (vColIndex >= table.getColumnCount()) {
            return -1;
        }
        return table.getColumnModel().getColumn(vColIndex).getModelIndex();
    }

    public int modelToView(JTable table, int mColIndex) {
        for (int c = 0; c < table.getColumnCount(); ++c) {
            TableColumn col = table.getColumnModel().getColumn(c);
            if (col.getModelIndex() != mColIndex) continue;
            return c;
        }
        return -1;
    }

    public static final void packWindow(final Component startComponent) {
        if (packBug) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Component component = startComponent; component != null; component = component.getParent()) {
                    try {
                        ((Window)component).pack();
                        return;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
            }
        });
    }

    public static final JFrame newJFrame(String title, Component component, final boolean exit) {
        final JFrame jFrame = new JFrame(title);
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (exit) {
                    System.exit(0);
                }
                jFrame.setVisible(false);
            }
        });
        jFrame.getContentPane().add(component, "Center");
        jFrame.pack();
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
        return jFrame;
    }

    public static ImageIcon loadActionIcon(String action) {
        return Util.loadImageIcon("data", "images", "button", action + ".png");
    }

    public static ImageIcon loadImageIcon(String ... names) {
        URL url = Config.getDataUrl(names);
        return url != null ? new ImageIcon(url) : null;
    }

    public static Image loadImage(String ... names) {
        try {
            return Util.loadImageIcon(names).getImage();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static final AudioClip loadAudio(String ... names) {
        URL url = Config.getDataUrl(names);
        return url != null ? Applet.newAudioClip(url) : null;
    }

    public static final Hashtable<String, Method> collectMethod(Class javaClass, List<String> ... actions) {
        Hashtable<String, Method> actionsMethod = new Hashtable<String, Method>();
        for (List<String> arg : actions) {
            for (String action : arg) {
                try {
                    actionsMethod.put(action, javaClass.getMethod("action" + action, new Class[0]));
                }
                catch (NoSuchMethodException e) {
                    try {
                        actionsMethod.put(action, javaClass.getMethod("action" + action, Boolean.TYPE));
                    }
                    catch (NoSuchMethodException e1) {
                        Log.keepLastException("Util::collectMethod can't find methode action" + action, e1);
                        e.printStackTrace();
                    }
                }
            }
        }
        return actionsMethod;
    }

    public static final Hashtable<String, AbstractButton> collectButtons(Hashtable<String, AbstractButton> buttons, JMenu jMenu) {
        if (buttons == null) {
            buttons = new Hashtable();
        }
        for (int i = 0; i < jMenu.getItemCount(); ++i) {
            try {
                JMenuItem button = jMenu.getItem(i);
                buttons.put(button.getActionCommand(), button);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return buttons;
    }

    public static void setAccelerator(Hashtable<String, AbstractButton> buttons, ActionControl ... actionsControl) {
        for (ActionControl actionControl : actionsControl) {
            ((JMenuItem)buttons.get(actionControl.action)).setAccelerator(KeyStroke.getKeyStroke(actionControl.key, actionControl.control ? 128 : 0));
        }
    }

    public static final Hashtable<String, AbstractButton> collectButtons(Hashtable<String, AbstractButton> buttons, Container container) {
        if (buttons == null) {
            buttons = new Hashtable();
        }
        for (Component component : container.getComponents()) {
            try {
                AbstractButton button = (AbstractButton)component;
                buttons.put(button.getActionCommand(), button);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return buttons;
    }

    public static final void actionPerformed(final Hashtable<String, Method> actionsMethod, ActionEvent e, final Object object) {
        String cmd = null;
        try {
            final Object source = e.getSource();
            if (source instanceof AbstractButton) {
                cmd = ((AbstractButton)source).getActionCommand();
            } else if (source instanceof JComboBox) {
                cmd = ((JComboBox)source).getActionCommand();
            }
            final String cmd2 = cmd;
            if (cmd2 != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (source instanceof JCheckBoxMenuItem) {
                            try {
                                boolean value = ((JCheckBoxMenuItem)source).isSelected();
                                ((Method)actionsMethod.get(cmd2)).invoke(object, value);
                                Util.updateCheckBox(cmd2, value);
                                return;
                            }
                            catch (IllegalArgumentException value) {
                            }
                            catch (Exception e1) {
                                Log.keepLastException("Util::actionPerformed (action " + cmd2 + " on " + object + ")", e1);
                                return;
                            }
                        }
                        try {
                            ((Method)actionsMethod.get(cmd2)).invoke(object, new Object[0]);
                        }
                        catch (Exception e1) {
                            Log.keepLastException("Util::actionPerformed (action " + cmd2 + " on " + object + ")", e1);
                        }
                    }
                });
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            Log.keepLastException("Util::actionPerformed (action " + cmd + " on " + object + ")", e2);
        }
    }

    public static List<String> merge(List<String> ... args) {
        ArrayList<String> result = new ArrayList<String>();
        for (List<String> arg : args) {
            result.addAll(arg);
        }
        return result;
    }

    public static String getExtention(File file) {
        return Util.getExtention(file.getName());
    }

    public static String getExtention(String filename) {
        try {
            filename = filename.substring(filename.lastIndexOf(".")).toLowerCase();
            return filename.substring(1);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getBase(File file) {
        return Util.getBase(file.getName());
    }

    public static String getBase(String filename) {
        try {
            return filename.substring(0, filename.lastIndexOf("."));
        }
        catch (Exception e) {
            return filename;
        }
    }

    public static String changeExtention(String filename, String extention) {
        try {
            return filename.substring(0, filename.lastIndexOf(".")) + "." + extention;
        }
        catch (Exception e) {
            return filename + "." + extention;
        }
    }

    public static void backup(File file, String extention, String backExtention) {
        if (!file.exists()) {
            return;
        }
        String newFileName = file.getName();
        if (newFileName.endsWith("." + extention)) {
            newFileName = newFileName.substring(0, newFileName.length() - ("." + extention).length());
        }
        File backFile = new File(file.getParent(), newFileName + "." + backExtention);
        backFile.delete();
        try {
            Files.move(file.toPath(), backFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void copy(InputStream src, OutputStream dst, byte[] tmp, ProgressState progressState) throws IOException {
        Util.copy(src, dst, tmp, progressState, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream src, OutputStream dst, byte[] tmp, ProgressState progressState, boolean srcClose, boolean dstClose) throws IOException {
        try {
            if (tmp == null) {
                tmp = new byte[0x100000];
            }
            while (true) {
                if (progressState != null && progressState.isInterrupted()) {
                    return;
                }
                int nbRead = src.read(tmp, 0, tmp.length);
                if (nbRead < 0) {
                    break;
                }
                dst.write(tmp, 0, nbRead);
                if (progressState == null || progressState.addValue(nbRead)) continue;
                return;
            }
        }
        finally {
            dst.flush();
            try {
                if (dstClose) {
                    dst.close();
                }
                if (srcClose) {
                    src.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static final String ctrlName(String s) {
        return s.replaceAll("[^0-9a-zA-Z_\\-.]", "");
    }

    public static final String toCapital(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase();
    }

    public static final <T> boolean containsOne(Collection<T> set1, Collection<T> set2) {
        try {
            if (set1.size() > set2.size()) {
                Collection<T> tmp = set1;
                set1 = set2;
                set2 = tmp;
            }
            for (T e : set1) {
                if (!set2.contains(e)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static final boolean containsPart(String subString, Collection<String> set) {
        if (set == null) {
            return false;
        }
        for (String s : set) {
            if (s.indexOf(subString) < 0) continue;
            return true;
        }
        return false;
    }

    public static final String getClassName(Class aClass) {
        String[] path = aClass.getName().split("\\.");
        return path[path.length - 1];
    }

    public static boolean cmp(String s1, String s2) {
        return s1 == s2 || s1 != null && s1.equals(s2);
    }

    static int max(int ... values) {
        int result = 0;
        for (int val : values) {
            result = Math.max(result, val);
        }
        return result;
    }

    public static void sleep(int s) {
        try {
            Thread.sleep(s * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void deciSleep(int s) {
        try {
            Thread.sleep(s * 100);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static String convertToHex(byte[] data) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (two_halfs++ < 1);
        }
        return buf.toString();
    }

    public static String sha1(String text) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] sha1hash = new byte[40];
        md.update(text.getBytes("iso-8859-1"), 0, text.length());
        sha1hash = md.digest();
        return Util.convertToHex(sha1hash);
    }

    static {
        Util.GBC.insets = new Insets(1, 2, 1, 2);
        Util.GBC.weighty = 1.0;
        Util.GBC.weightx = 1.0;
        Util.GBC.fill = 2;
        GBCLNL = (GridBagConstraints)GBC.clone();
        Util.GBCLNL.anchor = 17;
        Util.GBCLNL.fill = 0;
        Util.GBCLNL.gridwidth = 0;
        GBCNL = (GridBagConstraints)GBC.clone();
        Util.GBCNL.gridwidth = 0;
        GBCBNL = (GridBagConstraints)GBCNL.clone();
        Util.GBCBNL.fill = 1;
        allCheckBox = new Hashtable();
        space = new Dimension(10, 10);
        packBug = false;
    }

    public static class ActionControl {
        String action;
        int key;
        boolean control;

        public ActionControl(String action, int key) {
            this(action, key, true);
        }

        public ActionControl(String action, int key, boolean control) {
            this.action = action;
            this.key = key;
            this.control = control;
        }
    }

    public static class CheckIconTableCellEditorRenderer
    implements TableCellRenderer {
        JCheckBox jCheckBox;

        public CheckIconTableCellEditorRenderer(String action) {
            this.jCheckBox = Util.newCheckIcon(action, null);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.jCheckBox.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            this.jCheckBox.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
            if (value instanceof Boolean) {
                this.jCheckBox.setSelected((Boolean)value);
            }
            return this.jCheckBox;
        }
    }
}

