/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButton;
import junit.framework.JUnit4TestAdapter;
import misc.Bundle;
import misc.Util;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.JUnitCore;

public class UtilTest
extends Assert {
    public static final List<String> actions = Arrays.asList("Open", "Save", "Quit");
    public static final ActionListener actionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    };

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(UtilTest.class);
    }

    public static void main(String[] args) {
        JUnitCore.main((String[])new String[]{"misc.UtilTest"});
    }

    public static final void isCapital(String s) {
        UtilTest.assertTrue((boolean)Character.isUpperCase(s.charAt(0)));
        for (int i = 1; i < s.length(); ++i) {
            UtilTest.assertTrue((boolean)Character.isLowerCase(s.charAt(i)));
        }
    }

    @BeforeClass
    public static void createTestConfig() {
        Bundle.load("BundleManager");
    }

    @Test
    public void addRadioButton() {
        Container container = new Container();
        ButtonGroup group = new ButtonGroup();
        Util.addRadioButton(actions, actionListener, group, "Quit", container);
        UtilTest.assertTrue((boolean)actions.contains(group.getSelection().getActionCommand()));
        UtilTest.assertTrue((container.getComponentCount() == actions.size() ? 1 : 0) != 0);
        for (Component component : container.getComponents()) {
            JRadioButton button = (JRadioButton)component;
            UtilTest.assertTrue((boolean)actions.contains(button.getActionCommand()));
            Arrays.asList(button.getActionListeners()).contains(actionListener);
            if ("Quit".equals(button.getActionCommand())) {
                UtilTest.assertEquals((Object)group.getSelection().getActionCommand(), (Object)button.getActionCommand());
                UtilTest.assertTrue((boolean)button.isSelected());
                continue;
            }
            UtilTest.assertFalse((boolean)button.isSelected());
        }
    }

    @Test
    public void addButton() {
        Container container = new Container();
        Util.addButton(actions, actionListener, container);
        UtilTest.assertTrue((container.getComponentCount() == actions.size() ? 1 : 0) != 0);
        for (Component component : container.getComponents()) {
            JButton button = (JButton)component;
            UtilTest.assertTrue((boolean)actions.contains(button.getActionCommand()));
            Arrays.asList(button.getActionListeners()).contains(actionListener);
        }
    }

    @Test
    public void addIconButton() {
        Container container = new Container();
        Util.addIconButton(actions, actionListener, container);
        UtilTest.assertTrue((container.getComponentCount() == actions.size() ? 1 : 0) != 0);
        for (Component component : container.getComponents()) {
            JButton button = (JButton)component;
            UtilTest.assertNotNull((Object)button.getIcon());
            UtilTest.assertTrue((boolean)actions.contains(button.getActionCommand()));
            Arrays.asList(button.getActionListeners()).contains(actionListener);
        }
    }

    @Test
    public void addMenuItem() {
        Container container = new Container();
        Util.addMenuItem(actions, actionListener, container);
        UtilTest.assertTrue((container.getComponentCount() == actions.size() ? 1 : 0) != 0);
        for (Component component : container.getComponents()) {
            JMenuItem item = (JMenuItem)component;
            UtilTest.assertTrue((boolean)actions.contains(item.getActionCommand()));
            Arrays.asList(item.getActionListeners()).contains(actionListener);
        }
    }

    @Test
    public void addCheckMenuItem() {
        Container container = new Container();
        Util.addCheckMenuItem(actions, actionListener, container);
        UtilTest.assertTrue((container.getComponentCount() == actions.size() ? 1 : 0) != 0);
        for (Component component : container.getComponents()) {
            JMenuItem item = (JMenuItem)component;
            UtilTest.assertTrue((boolean)actions.contains(item.getActionCommand()));
            Arrays.asList(item.getActionListeners()).contains(actionListener);
        }
    }

    @Test
    public void addJMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        Util.addJMenu(jMenuBar, "Help");
    }

    @Test
    public void setColumnLabels() {
    }

    @Test
    public void packWindow() {
    }

    @Test
    public void newJFrame() {
    }

    @Test
    public void WindowAdapter() {
    }

    @Test
    public void windowClosing() {
    }

    @Test
    public void loadActionIcon() {
    }

    @Test
    public void loadImageIcon() {
    }

    @Test
    public void getDataUrl() {
    }

    @Test
    public void collectMethod() {
    }

    @Test
    public void collectButtons() {
    }

    @Test
    public void actionPerformed() {
    }

    @Test
    public void merge() {
    }

    @Test
    public void toCapital() {
        for (String s : Arrays.asList("abcd", "AbCd", "aBcD", "ABCD")) {
            UtilTest.isCapital(Util.toCapital(s));
        }
    }

    @Test(timeout=1500L)
    public void sleep() {
        long before = System.currentTimeMillis();
        Util.sleep(1);
        long after = System.currentTimeMillis();
        long delta = after - before;
        UtilTest.assertTrue((delta > 900L && delta < 1100L ? 1 : 0) != 0);
    }
}

