/*
 * Decompiled with CFR 0.152.
 */
package tp6.model;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import misc.StateNotifier;
import tp6.model.AutoScan;
import tp6.model.GameReceived;
import tp6.model.GameSend;
import tp6.model.ICom;
import tp6.model.IGame;
import tp6.model.Letter;
import tp6.model.Player;
import tp6.model.Proposal;

public class Game
extends StateNotifier
implements IGame {
    public static final String defaultDiscoverNet = "239.73.85.84";
    public static final int defaultDiscoverPort = 17997;
    public static final int defaultGamePort = 13622;
    private String localHost;
    private int gamePort;
    private GameSend gameSend;
    private GameReceived gameReceived;
    private AutoScan autoScan;
    private ArrayList<Proposal> proposals;
    private Player owner;
    private ArrayList<Player> knownedPlayers;
    private ArrayList<Player> guestingPlayers;
    private ArrayList<Player> players;
    private ArrayList<Letter> letters;
    private int nbPlayers;
    private int nbDone;
    private int nbScore;
    public ArrayList<Player> lastWinners;
    private Hashtable<Player, Integer> scores;
    public boolean closeGame;
    public boolean doneSended;

    public String getLocalHost() {
        return this.localHost;
    }

    @Override
    public Player getOwner() {
        return this.owner;
    }

    @Override
    public List<Proposal> getProposals() {
        return this.proposals;
    }

    @Override
    public List<Letter> getLetters() {
        return this.letters;
    }

    @Override
    public List<Player> getPlayers() {
        return this.players;
    }

    @Override
    public List<Player> getGuestingPlayers() {
        return this.guestingPlayers;
    }

    @Override
    public List<Player> getKnownedPlayers() {
        return this.knownedPlayers;
    }

    public boolean isClosed() {
        return this.closeGame;
    }

    @Override
    public int getScore(Player player) {
        try {
            return this.scores.get(player);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public Game(int gamePort) {
        block4: {
            this.gameSend = new GameSend(this);
            this.gameReceived = new GameReceived(this);
            this.proposals = new ArrayList();
            this.knownedPlayers = new ArrayList();
            this.guestingPlayers = new ArrayList();
            this.players = new ArrayList();
            this.letters = new ArrayList();
            this.nbPlayers = 0;
            this.nbDone = 0;
            this.nbScore = 0;
            this.lastWinners = new ArrayList();
            this.scores = new Hashtable();
            this.closeGame = false;
            this.doneSended = false;
            this.gamePort = gamePort;
            this.localHost = "127.0.0.1";
            try {
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                while (interfaces.hasMoreElements()) {
                    NetworkInterface current = interfaces.nextElement();
                    if (!current.isUp() || current.isLoopback() || current.isVirtual() || current.isPointToPoint()) continue;
                    Enumeration<InetAddress> addresses = current.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        InetAddress current_addr = addresses.nextElement();
                        if (current_addr.isLoopbackAddress()) continue;
                        this.localHost = current_addr.getHostAddress();
                        break block4;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setCom(ICom com) {
        if (this.autoScan != null) {
            this.autoScan.stopScan();
        }
        this.gameSend.setCom(com);
        this.autoScan = new AutoScan(this.gameReceived, com);
    }

    public void introducePlayer(Player player) {
        System.out.println("introduce: " + player);
        this.updateKnownedPlayers(Arrays.asList(player));
    }

    @Override
    public void addGuesting(Player player) {
        if (this.players.contains(player) || this.guestingPlayers.contains(player)) {
            return;
        }
        player = this.findNewPlayer(player);
        this.guestingPlayers.add(player);
        this.broadcastUpdate("GuestingChange");
        this.update();
    }

    @Override
    public void addKnownedPlayer(Player player) {
        this.updateKnownedPlayers(Arrays.asList(player));
        this.update();
    }

    @Override
    public void addKnownedPlayers(List<Player> newPlayers) {
        this.updateKnownedPlayers(newPlayers);
        this.update();
    }

    private void updateKnownedPlayers(List<Player> newPlayers) {
        boolean update = false;
        for (Player player : newPlayers) {
            Player oldPlayer = this.findPlayer(player, this.knownedPlayers);
            if (oldPlayer == null) {
                this.knownedPlayers.add(player);
                update = true;
                continue;
            }
            if (oldPlayer == this.owner) continue;
            update |= oldPlayer.updateIcon(player);
        }
        if (update) {
            Collections.sort(this.knownedPlayers, Player.nameComparator);
            this.broadcastUpdate("KnownedChange");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void giveLetter(Letter letter) {
        ArrayList<Letter> arrayList = this.letters;
        synchronized (arrayList) {
            this.letters.add(letter);
        }
        this.broadcastUpdate("LettersChange");
        this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPlayers(List<Player> newPlayers) {
        int addedPlayersCount = 0;
        int guestingRemoveCount = 0;
        ArrayList<Letter> arrayList = this.letters;
        synchronized (arrayList) {
            for (Player player : newPlayers) {
                if ((player = this.findNewPlayer(player)) != this.owner) {
                    player.setState(Player.PlayerState.player);
                }
                if (this.guestingPlayers.contains(player)) {
                    this.guestingPlayers.remove(player);
                    ++guestingRemoveCount;
                }
                if (this.players.contains(player)) continue;
                this.players.add(player);
                ++addedPlayersCount;
                this.letters.add(new Letter(("" + Character.forDigit(this.nbPlayers + 10, 36)).toUpperCase(), this.owner));
                ++this.nbPlayers;
            }
        }
        if (guestingRemoveCount > 0) {
            this.broadcastUpdate("GuestingChange");
        }
        if (addedPlayersCount <= 0) {
            return;
        }
        Collections.sort(this.players, Player.nameComparator);
        this.gameSend.sendWelcome();
        this.broadcastUpdate("LettersChange");
        this.broadcastUpdate("PlayersChange");
        this.update();
    }

    @Override
    public void addProposal(Proposal proposal) {
        this.proposals.add(proposal);
        this.broadcastUpdate("ProposalsChange");
        this.update();
    }

    public void setPlayer(String name, String avatar) {
        if (this.players.size() > 1) {
            System.err.println("can't change identity during game on");
            return;
        }
        if (this.owner != null) {
            this.owner.changeIdent(name, avatar);
            this.broadcastUpdate("LettersChange");
            this.broadcastUpdate("PlayersChange");
            this.broadcastUpdate("OwnerChange");
            return;
        }
        this.owner = new Player(name, this.localHost, this.gamePort, avatar);
        this.owner.setState(Player.PlayerState.owner);
        this.knownedPlayers.add(this.owner);
        this.addPlayers(Arrays.asList(this.owner));
        this.broadcastUpdate("KnownedChange");
        this.broadcastUpdate("OwnerChange");
    }

    @Override
    public void setAvatar(Player player, String avatar) {
        this.findNewPlayer(player).setAvatar(avatar);
        this.broadcastUpdate("AvatarChange");
    }

    @Override
    public void rejectLetter(Proposal proposal) {
        if (!this.proposals.contains(proposal)) {
            return;
        }
        this.proposals.remove(proposal);
        this.gameSend.sendReject(proposal.getPlayer(), proposal.getLetter());
        this.broadcastUpdate("ProposalsChange");
        this.update();
    }

    @Override
    public void welcomePlayer(Player player) {
        if (player == null) {
            return;
        }
        this.addPlayers(Arrays.asList(player));
    }

    @Override
    public void dismissPlayer(Player player) {
        this.guestingPlayers.remove(player);
        this.broadcastUpdate("GuestingChange");
        this.gameSend.sendDismiss(player);
    }

    @Override
    public void guestPlayer(Player player) {
        if (player == null || player.equals(this.owner) || this.players.contains(player) || player.getState() == Player.PlayerState.engaged) {
            return;
        }
        player.setState(Player.PlayerState.guested);
        this.broadcastUpdate("KnownedChange");
        this.gameSend.sendGuest(player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendLetter(Player player, Letter letter) {
        if (player == null || player.equals(this.owner) || !this.players.contains(player) || letter == null) {
            return;
        }
        ArrayList<Letter> arrayList = this.letters;
        synchronized (arrayList) {
            for (Proposal proposal : this.proposals) {
                if (!proposal.getPlayer().equals(player)) continue;
                this.letters.remove(letter);
                this.letters.add(proposal.getLetter());
                this.proposals.remove(proposal);
                this.broadcastUpdate("ProposalsChange");
                this.broadcastUpdate("LettersChange");
                this.update();
                this.gameSend.sendAnswer(player, letter);
                return;
            }
            if (this.closeGame) {
                return;
            }
            this.letters.remove(letter);
        }
        this.broadcastUpdate("LettersChange");
        this.update();
        this.gameSend.sendSend(player, letter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkWin(List<Letter> letters) {
        List<Letter> list = letters;
        synchronized (list) {
            int nbLetters = letters.size();
            if (nbLetters < 1 || this.nbPlayers != nbLetters) {
                return false;
            }
            String alpha = letters.get(0).getAlpha();
            for (Letter letter : letters) {
                if (letter.getAlpha().equals(alpha)) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkFull() {
        ArrayList<Letter> arrayList = this.letters;
        synchronized (arrayList) {
            int nbLetters = this.letters.size();
            if (!this.closeGame || this.doneSended || this.letters.size() < 1 || this.nbPlayers != this.letters.size()) {
                return;
            }
        }
        ++this.nbDone;
        this.doneSended = true;
        this.gameSend.sendFull();
        this.checkAllDone();
    }

    public void checkAllDone() {
        if (this.nbDone != this.nbPlayers) {
            return;
        }
        this.gameSend.sendDone(this.letters);
        this.incrScore(this.owner, this.checkWin(this.letters));
    }

    @Override
    public void checkScore(Player sender, List<Letter> letters) {
        this.incrScore(sender, this.checkWin(letters));
    }

    public void resetWinner() {
        if (this.closeGame) {
            return;
        }
        this.closeGame = true;
        this.broadcastUpdate("CloseChange");
        this.lastWinners.clear();
        this.nbScore = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ArrayList<Letter> arrayList = this.letters;
        synchronized (arrayList) {
            if (this.letters.size() < 2 || !this.checkWin(this.letters) || this.closeGame) {
                return;
            }
        }
        this.resetWinner();
        ++this.nbDone;
        this.doneSended = true;
        this.gameSend.sendClose();
        this.rejectAll();
        this.checkAllDone();
    }

    @Override
    public void rcvClose() {
        ++this.nbDone;
        this.resetWinner();
        this.checkFull();
    }

    @Override
    public void rcvFull() {
        ++this.nbDone;
        this.checkAllDone();
    }

    public void update() {
    }

    @Override
    public Player findNewPlayer(String name, String ip, int port) {
        return this.findNewPlayer(new Player(name, ip, port));
    }

    public Player findNewPlayer(Player refPlayer) {
        Player oldPlayer = this.findPlayer(refPlayer, this.knownedPlayers);
        if (oldPlayer == null) {
            oldPlayer = refPlayer;
            this.knownedPlayers.add(oldPlayer);
        }
        return oldPlayer;
    }

    public Player findPlayer(Letter letter) {
        return this.findPlayer(letter.getPlayer(), this.knownedPlayers);
    }

    public Player findPlayer(Player refPlayer, List<Player> players) {
        for (Player player : players) {
            if (!player.equals(refPlayer)) continue;
            return player;
        }
        return null;
    }

    public void incrScore(Player player, boolean winner) {
        int value = winner ? 1 : 0;
        Integer old = this.scores.get(player);
        if (old != null) {
            value += old.intValue();
        }
        this.scores.put(player, value);
        ++this.nbScore;
        if (winner) {
            this.lastWinners.add(player);
        }
        if (this.nbScore != this.nbPlayers) {
            return;
        }
        this.broadcastDisplay("Winners", this);
        this.resetGame();
        this.update();
    }

    public void rejectAll() {
        for (Proposal proposal : this.proposals) {
            this.gameSend.sendReject(proposal.getPlayer(), proposal.getLetter());
        }
        this.proposals.clear();
        this.broadcastUpdate("ProposalsChange");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetGame() {
        ArrayList<Letter> arrayList = this.letters;
        synchronized (arrayList) {
            this.letters.clear();
            this.proposals.clear();
            for (int i = 0; i < this.nbPlayers; ++i) {
                this.letters.add(new Letter(("" + Character.forDigit(i + 10, 36)).toUpperCase(), this.owner.getIp(), this.owner.getPort()));
            }
        }
        this.doneSended = false;
        this.closeGame = false;
        this.nbDone = 0;
        this.broadcastUpdate("CloseChange");
        this.broadcastUpdate("ProposalsChange");
        this.broadcastUpdate("LettersChange");
        this.broadcastUpdate("PlayersChange");
        this.update();
    }
}

