/*
 * Decompiled with CFR 0.152.
 */
package tp6.model;

import java.util.List;
import tp6.model.ICom;
import tp6.model.IGame;
import tp6.model.Letter;
import tp6.model.Player;

public class GameSend {
    private IGame game;
    private ICom com;

    public GameSend(IGame game) {
        this.game = game;
    }

    public void setCom(ICom com) {
        this.com = com;
    }

    public void sendAvatar() {
        String avatar = this.game.getOwner().getAvatar();
        if (avatar == null) {
            return;
        }
        this.com.sendAllMsg(this.game.getPlayers(), "avatar " + avatar);
    }

    public void sendWelcome() {
        String msg = "welcome";
        for (Player player : this.game.getPlayers()) {
            msg = msg + " " + player;
        }
        this.com.sendAllMsg(this.game.getPlayers(), msg);
        this.sendAvatar();
    }

    public void sendReject(Player player, Letter letter) {
        this.com.sendMsg(player, "reject " + letter);
    }

    public void sendDismiss(Player player) {
        this.com.sendMsg(player, "dismiss");
    }

    public void sendGuest(Player player) {
        this.com.sendMsg(player, "guest");
        this.sendAvatar();
    }

    public void sendSend(Player player, Letter letter) {
        this.com.sendMsg(player, "send " + letter);
    }

    public void sendAnswer(Player player, Letter letter) {
        this.com.sendMsg(player, "answer " + letter);
    }

    public void sendClose() {
        this.com.sendAllMsg(this.game.getPlayers(), "close");
    }

    public void sendFull() {
        this.com.sendAllMsg(this.game.getPlayers(), "full");
    }

    public void sendDone(List<Letter> letters) {
        this.com.sendAllMsg(this.game.getPlayers(), "done " + Letter.toString(letters));
    }
}

