/*
 * Decompiled with CFR 0.152.
 */
package tp6.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tp6.model.Game;
import tp6.model.ICom;
import tp6.model.Player;

public class TxtCom
implements ICom {
    public static final BufferedReader sysin = new BufferedReader(new InputStreamReader(System.in));
    static Pattern consolPattern = Pattern.compile("\\s*(\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3})\\s*:\\s*(\\d{1,5})\\s*(.*)");
    private Game game;

    public TxtCom(Game game) {
        this.game = game;
    }

    @Override
    public void sendMsg(Player player, String msg) {
        System.out.println("    " + this.game.getOwner() + " > " + player + ": " + msg);
        try {
            Player owner = this.game.getOwner();
            if (player == null || player.equals(owner)) {
                return;
            }
            msg = ICom.getTimeStamp() + " " + owner.getName() + ": " + msg + "\n";
            System.out.print(msg);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void sendAllMsg(List<Player> players, String msg) {
        System.out.println("    " + this.game.getOwner() + " > all: " + msg);
        for (Player player : players) {
            if (player.equals(this.game.getOwner())) continue;
            this.sendMsg(player, msg);
        }
    }

    @Override
    public ICom.Packet receiveMsg() throws IOException {
        String line = sysin.readLine();
        String ip = "";
        int port = 0;
        String msg = line;
        Matcher m = consolPattern.matcher(line);
        boolean b = m.matches();
        if (b) {
            ip = m.group(1);
            port = Integer.parseInt(m.group(2));
            msg = m.group(3);
        } else {
            System.err.println("    Consol simulation: \"ip:port msg\" != " + line);
        }
        return new ICom.Packet(ip, port, msg);
    }
}

