/*
 * Decompiled with CFR 0.152.
 */
package tp6.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import misc.Bundle;
import misc.Util;
import tp6.view.JCard;

public class JCards<T extends JCard>
extends JScrollPane {
    String title;
    TitledBorder titledBorder;
    public ArrayList<T> jCards = new ArrayList();
    JPanel screen = new JPanel();

    public JCards(String title) {
        this.title = title;
        this.setViewportView(this.screen);
        this.titledBorder = new TitledBorder(Bundle.getTitle(title));
        this.setBorder(this.titledBorder);
        this.setHorizontalScrollBarPolicy(30);
        this.setVerticalScrollBarPolicy(21);
        Bundle.addBundleObserver(this);
    }

    public void updateBundle() {
        this.titledBorder.setTitle(Bundle.getTitle(this.title));
        Util.packWindow(this);
        this.repaint();
    }

    public void leftClick(T jCard) {
    }

    public void rightClick(T jCard) {
    }

    public void addCard(T jCard) {
        this.getParent().invalidate();
        this.jCards.add(jCard);
        this.screen.add((Component)jCard);
        ((Component)jCard).addMouseListener(new MouseAdapter((JCard)jCard){
            final /* synthetic */ JCard val$jCard;
            {
                this.val$jCard = jCard;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    JCards.this.leftClick(this.val$jCard);
                } else if (SwingUtilities.isRightMouseButton(e)) {
                    JCards.this.rightClick(this.val$jCard);
                }
            }
        });
        Insets insets = this.titledBorder.getBorderInsets(this, new Insets(0, 0, 0, 0));
        this.setPreferredSize(new Dimension((55 + ((JCard)jCard).borderInsets.left + ((JCard)jCard).borderInsets.right) * this.getComponentCount() + insets.left + insets.right + 10, 90 + ((JCard)jCard).borderInsets.bottom + ((JCard)jCard).borderInsets.top + insets.bottom + insets.top));
        this.getParent().validate();
        Util.packWindow(this);
        this.repaint();
    }

    public void updateAvatarChange() {
        for (JCard jCard : this.jCards) {
            jCard.updateIcon();
        }
    }
}

