/*
 * Decompiled with CFR 0.152.
 */
package tp6.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import misc.Util;
import tp6.model.Game;
import tp6.model.Letter;
import tp6.model.Player;
import tp6.model.Proposal;
import tp6.view.JCard;
import tp6.view.JCards;
import tp6.view.JLetter;
import tp6.view.JPlayer;
import tp6.view.JProposal;

public class JGame
extends JPanel {
    public static final Dimension space = new Dimension(5, 5);
    Game game;
    JCards<JProposal> jProposals = new JCards<JProposal>("Proposals"){

        @Override
        public void rightClick(JProposal jCard) {
            JGame.this.game.rejectLetter(jCard.proposal);
        }
    };
    JCards<JLetter> jLetters = new JCards("Letters");
    JCards<JPlayer> jPlayers = new JCards("Players");
    JCards<JPlayer> jGuesting = new JCards<JPlayer>("Guesting"){

        @Override
        public void leftClick(JPlayer jCard) {
            JGame.this.game.welcomePlayer(jCard.player);
        }

        @Override
        public void rightClick(JPlayer jCard) {
            JGame.this.game.dismissPlayer(jCard.player);
        }
    };
    JCards<JPlayer> jKnowned = new JCards<JPlayer>("Knowned"){

        @Override
        public void leftClick(JPlayer jCard) {
            JGame.this.game.guestPlayer(jCard.player);
        }
    };
    JCard selectedJCard;
    Point relPos;

    public JGame(final Game game) {
        super(null);
        this.setLayout(new BoxLayout(this, 3));
        this.game = game;
        game.addUpdateObserver(this, "ProposalsChange", "LettersChange", "PlayersChange", "GuestingChange", "KnownedChange", "CloseChange", "AvatarChange");
        this.add(Box.createRigidArea(space));
        this.add(this.jProposals);
        this.add(Box.createRigidArea(space));
        this.add(this.jLetters);
        this.add(Box.createRigidArea(space));
        this.add(this.jPlayers);
        this.add(Box.createRigidArea(space));
        this.add(this.jGuesting);
        this.add(Box.createRigidArea(space));
        this.add(this.jKnowned);
        this.add(Box.createRigidArea(space));
        this.updateLettersChange();
        this.updatePlayersChange();
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    try {
                        4.sleep(250L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Game game2 = game;
                    synchronized (game2) {
                        JGame.this.updateTimeProposals();
                    }
                }
            }
        }.start();
    }

    public void startDragJCard(JCard jCard, MouseEvent e) {
        if (this.game.isClosed() && this.game.getProposals().size() < 1) {
            return;
        }
        JRootPane jRootPane = this.getRootPane();
        Point absPos = jRootPane.getMousePosition(true);
        this.relPos = e.getPoint();
        jCard.setBackground(Color.lightGray);
        jCard.setSize(e.getComponent().getSize());
        jCard.setLocation(absPos.x - this.relPos.x, absPos.y - this.relPos.y);
        JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
        if (this.selectedJCard != null) {
            jLayeredPane.remove(this.selectedJCard);
        }
        this.selectedJCard = jCard;
        jLayeredPane.add(jCard);
        jLayeredPane.setLayer(jCard, JLayeredPane.DRAG_LAYER);
        jCard.setVisible(true);
    }

    public void dragJCard() {
        try {
            Point absPos = this.getRootPane().getMousePosition(true);
            this.selectedJCard.setLocation(absPos.x - this.relPos.x, absPos.y - this.relPos.y);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stopDragJCard() {
        if (this.selectedJCard == null) {
            return;
        }
        this.selectedJCard.setVisible(false);
        this.getRootPane().getLayeredPane().remove(this.selectedJCard);
    }

    public void stopDragJLetter() {
        this.stopDragJCard();
        try {
            Player player = null;
            Component component = this.findComponentAt(this.getMousePosition(true));
            Container parent = null;
            while (parent != this) {
                parent = component.getParent();
                if (component instanceof JPlayer) {
                    player = ((JPlayer)component).player;
                    break;
                }
                if (component instanceof JProposal) {
                    player = ((JProposal)component).proposal.getPlayer();
                    break;
                }
                component = parent;
            }
            this.game.sendLetter(player, ((JLetter)this.selectedJCard).letter);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.selectedJCard = null;
    }

    public void stopDragJProposal() {
        this.stopDragJCard();
        try {
            Letter letter = null;
            Component component = this.findComponentAt(this.getMousePosition(true));
            Container parent = null;
            while (parent != this) {
                parent = component.getParent();
                if (component instanceof JLetter) {
                    letter = ((JLetter)component).letter;
                    break;
                }
                component = parent;
            }
            this.game.sendLetter(((JProposal)this.selectedJCard).proposal.getPlayer(), letter);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.selectedJCard = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTimeProposals() {
        Game game = this.game;
        synchronized (game) {
            for (JProposal jProposal : this.jProposals.jCards) {
                jProposal.setBackground(jProposal.proposal.getColor());
            }
        }
    }

    public void updateCloseChange() {
        this.jLetters.setBackground(this.game.isClosed() ? Color.gray : this.getBackground());
        if (this.game.isClosed() && this.game.getProposals().size() < 1) {
            this.stopDragJCard();
        }
        Util.packWindow(this);
        this.repaint();
    }

    public void updateProposalsChange() {
        this.jProposals.screen.removeAll();
        for (Proposal proposal : this.game.getProposals()) {
            this.jProposals.addCard(new JProposal(this, proposal));
        }
        if (this.selectedJCard != null && this.selectedJCard instanceof JProposal && !this.jProposals.jCards.contains(this.selectedJCard)) {
            this.stopDragJCard();
        }
        Util.packWindow(this);
        this.repaint();
    }

    public void updateLettersChange() {
        this.jLetters.screen.removeAll();
        for (Letter letter : this.game.getLetters()) {
            this.jLetters.addCard(new JLetter(this.game, letter, this));
        }
        Util.packWindow(this);
        this.repaint();
    }

    public void updatePlayersChange() {
        this.jPlayers.screen.removeAll();
        for (Player player : this.game.getPlayers()) {
            this.jPlayers.addCard(new JPlayer(player, this.game.getScore(player)));
        }
        this.updateGuestingChange();
    }

    public void updateGuestingChange() {
        this.jGuesting.screen.removeAll();
        for (Player player : this.game.getGuestingPlayers()) {
            this.jGuesting.addCard(new JPlayer(player, null));
        }
        this.updateKnownedChange();
    }

    public void updateKnownedChange() {
        this.jKnowned.screen.removeAll();
        for (Player player : this.game.getKnownedPlayers()) {
            if (player.equals(this.game.getOwner())) continue;
            switch (player.getState()) {
                case connected: 
                case guested: {
                    if (this.game.getGuestingPlayers().contains(player)) break;
                    this.jKnowned.addCard(new JPlayer(player, null));
                }
            }
        }
        Util.packWindow(this);
        this.repaint();
    }

    public void updateAvatarChange() {
        this.jProposals.updateAvatarChange();
        this.jLetters.updateAvatarChange();
        this.jPlayers.updateAvatarChange();
        this.jGuesting.updateAvatarChange();
        this.jKnowned.updateAvatarChange();
    }
}

